#ifndef DNB_PLAYER_MANAGER_H_
#define DNB_PLAYER_MANAGER_H_
#include <map>
#include "Player.h"

/**
 * @class PlayerManager
 * 
 * @brief Manages and stores all players in the current game
 */
class PlayerManager
{
public:
    PlayerManager() : m_numPlayers(0) {};
    
    /**
     * @brief Initialize PlayerManager
     */
    bool Init() 
    { 
        m_numPlayers = 0;
        m_players.clear();
        return true; 
    }
    
    void UpdatePlayer(int id, const iVec2& pos);

    void UpdateOurPlayer(const iVec2 &pos);

    const Player *GetOurPlayer() const;
    Player *GetOurPlayer();

    const Player *GetPlayer(int id) const;

    void KillAllPlayers();

    const std::map<int, Player>& GetPlayers() const { return m_players; };
private:
    std::map<int, Player> m_players; //!< Map of all players in the game, where the key is the id supplieded from the game server
    Player m_ourPlayer; //!< Pointer to this AI's player instance
    int m_numPlayers; //!< The number of player
};

#endif
