#ifndef DNB_PATH_VALIDATION_H_
#define DNB_PATH_VALIDATION_H_

#include "Map.h"

class SafePathValidation
{
public:
    template<class GraphType>
    static bool IsValid(const GraphType &graph, int nodeID, int cost)
    {
        char tile = graph.GetNode(nodeID).GetTile();
        
        // If this node is in range of a bomb.
        if(tile < 32)
        {
            //int diff = tile - cost; 
            return tile - cost > 1;
        }

        return tile != static_cast<char>(Tile::Bomb) && tile != static_cast<char>(Tile::Player); 
    }
};

#endif