#ifndef DNB_FOLLOW_PATH_H_
#define DNB_FOLLOW_PATH_H_

#include "OdinAI/Goals.h"
#include <list>

class Player;

class FollowPathGoal : public OdinAI::CompositeGoal
{
public:
    FollowPathGoal(Player *pOwner, const std::list<int> &path, bool destroyWalls=false) : m_pOwner(pOwner), m_path(path), m_destroyWalls(destroyWalls) {}

	/**
	 * Function called before a goal is processed.
	 */
	void Activate();

	/**
	 * Function used to process goal.
	 */
	int Process();

	/**
	 * Function used to clean up an goal.
	 */
	void End();
private:
    std::list<int> m_path;
    bool m_destroyWalls;
    Player *m_pOwner;
};

#endif