#ifndef DNB_FLEE_GOAL_H_
#define DNB_FLEE_GOAL_H_

#include "OdinAI/Goals.h"
#include "OdinAI/Event.h"
#include <list>
#include <vector>
#include "GameManager.h"

class Player;
class Map;

class FleeGoal : public OdinAI::CompositeGoal
{
public:
    FleeGoal(Player *pOwner, const std::vector< std::vector<char> > &map) : m_pOwner(pOwner), m_map(map)
    {
        gGameMgr.GetEventMgr().AddEventListener("mapChanged", std::bind(&FleeGoal::OnMapChanged, this, std::placeholders::_1), this);
    }

    /**
     * Function called before a goal is processed.
     */
    void Activate();

    /**
     * Function used to process an goal.
     */
    int Process();

    /**
     * Function used to clean up an goal.
     */
    void End();
 
   
    static std::list<int> CreateEscapePlan(Player* pOwner, const std::vector<std::vector<char>> &bombMap, bool useSafetyMargin=true);
    std::list<int> CreateEscapePlan(bool useSafetyMargin) { return CreateEscapePlan(m_pOwner, m_map, useSafetyMargin); };
 private:
    void OnMapChanged(const OdinAI::Event *pEvent);

    std::list<int> m_path;
    std::vector< std::vector<char> > m_map;
    Player *m_pOwner;
};

#endif