#ifndef ODINAI_NETWORK_MANAGER_H_
#define ODINAI_NETWORK_MANAGER_H_

#ifdef _WIN32

#ifndef WIN32_LEAN_AND_MEAN
#define WIN32_LEAN_AND_MEAN
#endif

#pragma comment(lib, "Ws2_32.lib")

#include <windows.h>
#include <winsock2.h>
#include <ws2tcpip.h>
#include <iphlpapi.h>
#endif

#include <map>
#include <vector>
#include <functional>

#include "SharedDefs.h"

namespace OdinAI
{
    typedef std::function<void(char*, int)> AsyncRecvCallback;

	/**
	 * Manages the network traffic.
	 */
	class NetworkManager
	{
	public:
        NetworkManager() : m_currentInPos(0), m_currentOutPos(0), m_bCanSend(false) { }

		/**
		 * Connects to the server. Our network implementation is async.
         * @param asyncRecvCallback Asynchronous callback for receive.
		 */
        bool Connect(const char *ip, const char *port, const AsyncRecvCallback &asyncRecvCallback);

		/**
		 * Checks for new packages.
		 */
		void Update();

		/**
		 * Closes the connection to server.
		 */
		void Close();

        /**
		 * Send message to server.
		 */
		void Send(const void *data, int size);
	private:
		/**
		 * Handles receives, when the socket is ready for that.
		 */
		void HandleReceive();

		/**
		 * Send data that are on the stack.
		 */
		void HandleSend();

#ifdef _WIN32
		SOCKET m_clientSocket;
		WSAData m_wsaData;
		WSAEVENT m_netEvent;
#else
		int m_clientSocket;
#endif
        AsyncRecvCallback m_asyncRecvCallback;

		int m_currentInPos;
        int m_currentOutPos;
		char m_netBuffer[NETWORK_BUFFER_SIZE];
		char m_outBuffer[NETWORK_BUFFER_SIZE];
		bool m_bCanSend;
	};
}

#endif
