/*******************************************************************************
 * ________       .___.__           _____  .___ 
 * \_____  \    __| _/|__| ____    /  _  \ |   |
 *  /   |   \  / __ | |  |/    \  /  /_\  \|   |
 * /    |    \/ /_/ | |  |   |  \/    |    \   |
 * \_______  /\____ | |__|___|  /\____|__  /___|
 *         \/      \/         \/         \/     
 *
 * Copyright (c) Emil Sandst 2012
 *******************************************************************************/
#ifndef ODINAI_GRAPH_NODES_H_
#define ODINAI_GRAPH_NODES_H_

namespace OdinAI
{
/**
 * Graph node is self-explained...
 * Implementation is based on the book:
 * Programming Game AI by Example.
 */
class GraphNode
{
public:
    GraphNode() : m_index(0) {}
    GraphNode(int index) : m_index(index) {}

    virtual ~GraphNode() {}

    void SetIndex(int index);
    int GetIndex() const;
protected:
    int m_index;//Graph node index.
};

template<class Vector>
class NavGraphNode : public GraphNode
{
public:
    NavGraphNode() {}

    NavGraphNode(int index) : GraphNode(index) {}

    NavGraphNode(int index, const Vector &v) : GraphNode(index), m_position(v) {}

    const Vector &GetPosition() const
    {
        return m_position;
    }

    void SetPosition(const Vector &position)
    {
        m_position = position;
    }
private:
    Vector m_position;
};

}
#endif