/*******************************************************************************
 * ________       .___.__           _____  .___ 
 * \_____  \    __| _/|__| ____    /  _  \ |   |
 *  /   |   \  / __ | |  |/    \  /  /_\  \|   |
 * /    |    \/ /_/ | |  |   |  \/    |    \   |
 * \_______  /\____ | |__|___|  /\____|__  /___|
 *         \/      \/         \/         \/     
 *
 * Copyright (c) Emil Sandst 2012
 *******************************************************************************/
#ifndef ODINAI_EVENT_H_
#define ODINAI_EVENT_H_

#include <string>
#include <memory>

#define DECLARE_EVENT(EventClass) \
    static std::shared_ptr<EventClass> Create() \
    { \
        std::shared_ptr<EventClass> pInstance(new EventClass, [=](EventClass *pEvent) { \
            pEvent->Release(); \
            delete pEvent;} \
        ); \
        return pInstance; \
    } \

namespace OdinAI
{

/**
 *  Event class is the base class for all types of events.
 */
class Event
{
public:
    DECLARE_EVENT(Event);

	virtual ~Event() {}

	/**
	 *  Release dynamic memory
	 */
	virtual void Release() {}

	/**
	 *  @return The event name.
	 */
	virtual const char *GetName() const
	{
		return "default";
	}
};

}

#endif
