package com.petterroea.util;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;

public class GraphicsUtils {
	public static int getCenter(int w, String s, Graphics g)
	{
		return (w/2)-(g.getFontMetrics().stringWidth(s)/2);
	}
	public static void setAlpha(byte alpha, BufferedImage img, int x, int y) {       
	    alpha %= 0xff; 
	            int color = img.getRGB(x, y);

	            int mc = (alpha << 24) | 0x00ffffff;
	            int newcolor = color & mc;
	            img.setRGB(x, y, newcolor);            

	}
	public static BufferedImage scale(BufferedImage in, float scale)
	{
		BufferedImage out = new BufferedImage((int)((float)in.getWidth()*scale), (int)((float)in.getHeight()*scale), BufferedImage.TYPE_INT_ARGB);
		for(int x = 0; x < out.getWidth(); x++)
		{
			for(int y = 0; y < out.getHeight(); y++)
			{
				out.setRGB(x, y, in.getRGB((int)((float)x/scale), (int)((float)y/scale)));
			}
		}
		return out;
	}
	public static int getRed(int rgb)
	{
		return (rgb >> 16) & 0xFF;
	}
	public static int getGreen(int rgb)
	{
		return (rgb >> 8) & 0xFF;
	}
	public static int getBlue(int rgb)
	{
		return rgb & 0xFF;
	}
	public static int getAlpha(int rgba)
	{
		return (rgba >> 24) & 0xFF;
	}
	public static int setRed(int rgb, int red)
	{
		return (rgb & 0xFF00FFFF) + ((red & 0xFF) << 16); 
	}
	public static int setGreen(int rgb, int green)
	{
		return (rgb & 0xFFFF00FF) + ((green & 0xFF) << 8); 
	}
	public static int setBlue(int rgb, int blue)
	{
		return (rgb & 0xFFFFFF00) + (blue & 0xFF);
	}
	public static int setAlpha(int rgba, int alpha)
	{
		return (rgba & 0x00FFFFFF) + ((alpha & 0xFF) << 24);
	}
	public static int setRgb(int rgb, int red, int green, int blue)
	{
		return setBlue(setGreen(setRed(rgb, red), green), blue);
	}
	public static int setRgba(int rgba, int red, int green, int blue, int alpha)
	{
		return setBlue(setGreen(setRed(setAlpha(rgba, alpha), red), green), blue);
	}
	public static int[] getRgb(int rgb)
	{
		return new int[]{getRed(rgb), getGreen(rgb), getBlue(rgb)};
	}
	public static int[] getRgba(int rgba)
	{
		return new int[]{getRed(rgba), getGreen(rgba), getBlue(rgba), getAlpha(rgba)};
	}
}
