package com.petterroea.util;

/**
 * Interface used by WwwUtils to notify of new download speed, so the user can display it somewhere, or use it for stats.
 * @author petterroea
 * @see WwwUtils
 * @since Commit 1
 */
public interface DownloadSpeedInterface {
	/**
	 * Called each time the downloader calculates new download speed(Every 150 kilobytes)
	 * @param kbitPerSec New download speed in kilobits per second
	 * @since Commit 1
	 */
	public void setNewSpeed(float kbitPerSec);
}
