/*
 * Decompiled with CFR 0.152.
 */
package tg2014;

import java.util.LinkedList;
import java.util.Queue;

public class GameData {
    public boolean dead = false;
    public char[][] map = null;
    public char[][] bombMap = null;
    public char[][] bombs = new char[32][2];
    public char[][] players = new char[32][2];
    public int[][] searchOrder;
    public int activeBombs;
    public int activePlayers;
    public int playerX;
    public int playerY;
    public int mapWidth;
    public int mapHeight;
    private int lastMapWidth;
    private int lastMapHeight;
    public Queue<Action> queue;

    public GameData() {
        int[][] nArrayArray = new int[4][];
        int[] nArray = new int[2];
        nArray[0] = -1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[2];
        nArray2[1] = -1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[2];
        nArray3[0] = 1;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[2];
        nArray4[1] = 1;
        nArrayArray[3] = nArray4;
        this.searchOrder = nArrayArray;
        this.activeBombs = 0;
        this.activePlayers = 0;
        this.playerX = 0;
        this.playerY = 0;
        this.mapWidth = 0;
        this.mapHeight = 0;
        this.lastMapWidth = -1;
        this.lastMapHeight = -1;
        this.queue = new LinkedList<Action>();
    }

    public void updateData(String[] packet) {
        int j = 0;
        while (j < packet.length) {
            if (packet[j] != null) {
                int a;
                int count;
                if (packet[j].charAt(0) == 'X') {
                    this.playerX = Integer.valueOf(packet[j].substring(2));
                } else if (packet[j].charAt(0) == 'Y') {
                    this.playerY = Integer.valueOf(packet[j].substring(2));
                } else if (packet[j].charAt(0) == 'H') {
                    this.mapHeight = Integer.valueOf(packet[j].substring(7));
                    this.mapWidth = Integer.valueOf(packet[j + 1].substring(6));
                    if (this.mapWidth != this.lastMapWidth || this.mapHeight != this.lastMapHeight) {
                        this.map = new char[this.mapHeight][this.mapWidth];
                        this.bombMap = new char[this.mapHeight][this.mapWidth];
                        this.lastMapWidth = this.mapWidth;
                        this.lastMapHeight = this.mapHeight;
                    }
                } else if (packet[j].equals("BOMBS")) {
                    count = 0;
                    a = j + 1;
                    while (!packet[a].equals("ENDBOMBS")) {
                        this.bombs[count][0] = (char)Integer.parseInt(packet[a].substring(0, packet[a].indexOf(44)));
                        this.bombs[count][1] = (char)Integer.parseInt(packet[a].substring(packet[a].indexOf(44) + 1, packet[a].indexOf(32)));
                        ++count;
                        ++a;
                    }
                    this.activeBombs = count;
                } else if (packet[j].equals("PLAYERS")) {
                    count = 0;
                    a = j + 1;
                    while (!packet[a].equals("ENDPLAYERS")) {
                        this.players[count][0] = (char)Integer.parseInt(packet[a].substring(packet[a].indexOf(32) + 1, packet[a].indexOf(44)));
                        this.players[count][1] = (char)Integer.parseInt(packet[a].substring(packet[a].indexOf(44) + 1));
                        ++count;
                        ++a;
                    }
                    this.activePlayers = count;
                } else if (packet[j].charAt(0) == 'M') {
                    int y = 0;
                    while (y < this.mapHeight) {
                        int x = 0;
                        while (x < this.mapWidth) {
                            this.map[y][x] = packet[j + 1 + y].charAt(x);
                            this.bombMap[y][x] = this.map[y][x];
                            ++x;
                        }
                        ++y;
                    }
                    this.updateBombMap(this.bombMap, this.bombs, this.activeBombs);
                }
            }
            ++j;
        }
    }

    private void updateBombMap(char[][] BMap, char[][] bombs, int activeBombs) {
        int i = 0;
        while (i < activeBombs) {
            char x = bombs[i][0];
            char y = bombs[i][1];
            int y1 = y - 2;
            while (y1 < y + 3) {
                if (y1 > 0 && y1 < BMap.length && BMap[y1][x] == '.') {
                    BMap[y1][x] = 66;
                }
                ++y1;
            }
            int x1 = x - 2;
            while (x1 < x + 3) {
                if (x1 > 0 && x1 < BMap[y].length && BMap[y][x1] == '.') {
                    BMap[y][x1] = 66;
                }
                ++x1;
            }
            ++i;
        }
    }

    public void prioritizeSearchOrder() {
        if (this.activePlayers > 0) {
            int i = 0;
            while (i < 4) {
                this.searchOrder[i][0] = 0;
                this.searchOrder[i][1] = 0;
                ++i;
            }
            char x = this.players[0][0];
            char y = this.players[0][1];
            int deltaX = this.playerX - x;
            int deltaY = this.playerY - y;
            if (Math.abs(deltaX) < Math.abs(deltaY)) {
                if (deltaX < 0) {
                    this.searchOrder[0][0] = 1;
                    this.searchOrder[2][0] = -1;
                } else {
                    this.searchOrder[0][0] = -1;
                    this.searchOrder[2][0] = 1;
                }
                if (deltaY < 0) {
                    this.searchOrder[1][1] = 1;
                    this.searchOrder[3][1] = -1;
                } else {
                    this.searchOrder[1][1] = -1;
                    this.searchOrder[3][1] = 1;
                }
            } else {
                if (deltaY < 0) {
                    this.searchOrder[0][1] = 1;
                    this.searchOrder[2][1] = -1;
                } else {
                    this.searchOrder[0][1] = -1;
                    this.searchOrder[2][1] = 1;
                }
                if (deltaX < 0) {
                    this.searchOrder[1][0] = 1;
                    this.searchOrder[3][0] = -1;
                } else {
                    this.searchOrder[1][0] = -1;
                    this.searchOrder[3][0] = 1;
                }
            }
        }
    }

    public static enum Action {
        NOTHING(""),
        GOLEFT("LEFT\n"),
        GORIGHT("RIGHT\n"),
        GODOWN("DOWN\n"),
        GOUP("UP\n"),
        PLACEBOMB("BOMB\n");

        public String comand = "";

        private Action(String c) {
            this.comand = c;
        }
    }
}

