window.onload = function() {

    // Setările
    var w = 1280, h = 720, bpm = 130, bpb = 4;
    var resources = {
        music: 'postgre.mp3',
        images: {
            title: 'title.svg',
            title2: 'title2.svg',
            title3: 'title3.svg',
            title4: 'title4.svg',
            hypno: 'hypno.jpg',
            hypno2: 'hypno2.jpg',
            aemeth: 'aemeth.svg',
            lauder: 'lauder.jpg',
            occult: 'occult.jpg',
            riderbohemian: 'riderbohemian.jpg',
            fabricus: 'fabricus.jpg',
            end: 'end.svg',
			supercell: 'supercell.jpg'
        }
    };

    // Inițializa motor
    var canvas = document.getElementById('canvas');
    canvas.width = w;
    canvas.height = h;
    var ctx = canvas.getContext('2d');
    var music = null;
    var images = {};

    function applyFilters(filters) {
        var str = '';
        if ( filters ) {
            for (var type in filters) {
                var unit = '';
                switch (type) {
                    case 'blur': unit = 'px'; break;
                    case 'hue-rotate': unit = 'deg'; break;
                }
                str += type + '(' + filters[type] + unit + ')';
            }
        }
        canvas.style.filter = str;
        canvas.style.webkitFilter = str;
    }

    function resize() {
        var cw = canvas.offsetWidth;
        var ch = canvas.offsetHeight;
        var w = window,
            d = document,
            e = d.documentElement,
            g = d.getElementsByTagName('body')[0],
            x = w.innerWidth || e.clientWidth || g.clientWidth,
            y = w.innerHeight|| e.clientHeight|| g.clientHeight;
        var cr = cw / ch, wr = x / y;
        if ( cr < wr ) {
            canvas.style.width = 'auto';
            canvas.style.height = y + 'px';
            canvas.style.marginTop = 0;
        } else {
            canvas.style.width = '100%';
            canvas.style.height = 'auto';
            canvas.style.marginTop = Math.round((y - ch) / 2) + 'px';
        }
    }
    resize();
    window.onresize = resize;

    // Lista de scene
    images.noise = createCanvas(function(noise) {
        var ctx = noise.getContext('2d');
        var image = ctx.getImageData(0, 0, w, h);
        for ( var i = 0, j = image.data.length; i < j; ) {
            var r = Math.floor(Math.random() * 256);
            image.data[i++] = r;
            image.data[i++] = r;
            image.data[i++] = r;
            image.data[i++] = 255;
        }
        ctx.putImageData(image, 0, 0);
    });
    
    var scenes = {
        titles: {
            start: 0,
            length: 16 * 4,

            update: function(time) {
                ctx.fillStyle = 'hsl(' + time.progress * 180 + ',10%,' + (time.progress * 50) + '%)';
                ctx.fillRect(0, 0, w, h);

                var title = time.progress < 0.5 ?  images.title : images.title2;
                ctx.save();
                ctx.translate(w / 2, h / 2);
                var s = time.progress;
                if ( time.progress < 0.25 ) s *= 0.1;
                if ( time.progress > 0.5 ) s *= 2;
                if ( time.progress > 0.75 ) s *= 5;
                if ( time.beat % bpb < 1.5 ) {
                    s = 150 - time.progress * 153;
                    title = images.title3;
                }
                if ( Math.random() < 0.01) s = Math.random() * 10;
                ctx.scale(s, s);
                ctx.drawImage(title, -w/2, -h/2);
                ctx.restore();
            }
        },
        titles2: {
            start: 'titles.end',
            length: 16 * 4,
            update: function(time) {
                ctx.fillStyle = 'hsl(' + (180 + time.progress * 180) + ',25%,' + (50 + time.progress * 50) + '%)';
                ctx.fillRect(0, 0, w, h);
                ctx.translate(w/2, h/2);
                if ( time.beat % bpb >= 1.5 ) {
                    var title = images.title4;
                    if ( time.progress >= 0.500 ) title = images.title;
                    if ( time.progress >= 0.625 ) title = images.title2;
                    if ( time.progress >= 0.750 ) title = images.title3;
                    if ( time.progress >= 0.875 ) title = images.title4;
                    
                    var s = time.progress + 1;
                    if ( Math.random() < 0.025) {
                        s = Math.random() * 10;
                        ctx.translate(-50 * Math.random() * 100, -50 * Math.random() * 100);
                    }
                    ctx.scale(s, s);
                    ctx.drawImage(title, Math.random() * 4 - 2 - w/2, -h/2);
                    this.filters.brightness = 1 - time.beat % 1;
                } else {
                    var s = 2 - time.progress;
                    if ( Math.random() < 0.1) s = Math.random() * 10;
                    ctx.scale(s, s);
                    ctx.globalAlpha = 0.5;
                    ctx.drawImage(time.beat % 8 < 4 ? images.hypno : images.hypno2, -w/2, -h/2);
                }
            }
        },
        aemeth: {
            start: 'titles2.end',
            length: 16 * 4,
            update: function(time) {
                ctx.fillStyle = 'hsl(' + (45 - time.progress * 45) + ',100%,' + (100 - time.progress * 50) + '%)';
                ctx.fillRect(0, 0, w, h);
                if ( time.beat % bpb >= 1.5 ) {
                    ctx.translate(640, 360);
                    var s = 1 + time.progress * 2;
                    if ( Math.random() < 0.1) s = Math.random() * 10;
                    ctx.scale(s, s);
                    ctx.drawImage(images.aemeth, -500, -500)
                } else {
                    var imgs = [images.lauder, images.riderbohemian, images.occult];
                    ctx.drawImage(imgs[Math.floor(Math.random() * imgs.length * time.progress)], 0, 0)
                    
                    // Particles
                    var count = 500;                
                    var coef = 2 * Math.PI / count;
                    var ea = 2 * Math.PI;
                    
                    if ( !this.particles ) {
                        var lines = [[0,1,-0.5877852522924732,-0.8090169943749473],[-0.5877852522924732,-0.8090169943749473,0.9510565162951535,0.3090169943749472],[0.9510565162951535,0.3090169943749472,-0.9510565162951534,0.30901699437494756],[-0.9510565162951534,0.30901699437494756,0.5877852522924728,-0.8090169943749477],[0.5877852522924728,-0.8090169943749477,5.510910588479072e-16,1]];
                        var lines2 = [[-1, -1, -1, 0], [-1, 0, 1, 0], [1, 0, 1, 1], [1, -1, 0, -1], [0, -1, 0, 1], [0, 1, -1, 1]];
						var p1 = [], p2 = [], p3 = [], p4 = [], p5 = [];
                        for ( var i = 0; i < count; i++ ) {
                            p1.push([Math.sin(i * coef * 3), Math.cos(i * coef * 3)]);
                            
							var line2 = lines2[Math.floor(i/84)];
							var t = (i % 84) / 84;
							p5.push([linear(line2[0], line2[2], t), linear(line2[1], line2[3], t)]);
							
                            var line = lines[Math.floor(i/100)];
                            var t = (i % 100) / 100;
                            p2.push([linear(line[0], line[2], t), linear(line[1], line[3], t)]);
                            
                            p3.push([Math.sin(i * coef * 5), Math.cos(i * coef * 5)]);
                            p4.push([Math.sin(i * coef * 8), Math.cos(i * coef * 8)]);
                        }
                        this.targets = [p1, p2, p5, p2, p3, p2, p4, p2]
                    }

                    var morphSpeed = 0.0003;
                    var i1 = Math.floor(time.time * morphSpeed) % this.targets.length;
                    var i2 = (i1 + 1) % this.targets.length;
                    var pts1 = this.targets[i1], pts2 = this.targets[i2];
                    
                    ctx.fillStyle = 'white';
                    ctx.translate(w/2, h/2);
                    ctx.scale(h*2/3, h*2/3);
                    ctx.rotate(-time.time * 0.001);
                    var t = (time.time * morphSpeed) % 1;
                    for ( var i = 0; i < count; i++ ) {
                        var p1 = pts1[i], p2 = pts2[i];
                        var x = linear(p1[0], p2[0], t);
                        var y = linear(p1[1], p2[1], t);
                        ctx.beginPath();
                        ctx.arc(x, y, 0.1 * Math.random(), 0, ea);
                        ctx.closePath();
                        ctx.fill();
                    }                    
                }
                
                if ( time.progress >= 0.9375 ) {
                    this.filters.brightness = 1 - (time.progress - 0.9375) * 16;
                }
            }
        },
        hasoc: {
            start: 'aemeth.end',
            length: 16 * 4,
            update: function(time) {
                //ctx.globalAlpha = Math.min(1, time.progress * 4);
                var imgs = [images.lauder, images.riderbohemian, images.occult, images.hypno,
                            images.title, images.title2, images.title3, images.title4];
                var image = images.fabricus;

                var s = 1 + time.progress * 0.3125;
                if ( Math.random() < 0.2 * time.progress) s = Math.random() * 10;
                if ( Math.random() < Math.pow(time.progress, 6)) image = imgs[Math.floor(Math.random() * imgs.length)];

                var sx = image.naturalWidth;
                var sy = image.naturalHeight;

                ctx.save();
                ctx.globalAlpha = 1 - Math.abs(1 - time.progress * 2);
                ctx.translate(w/2, h/2);
                ctx.scale(s, s);
                ctx.drawImage(image, -sx/2, -sy/2)
                ctx.restore();

                //
                var coefs = [0.000012, 0.000023, 0.000034, 0.000045, 0.000056];
                var pts = [];
                for ( var i = 0; i < 20; i++ ) {
                    pts.push([
                        Math.sin(i * 1.8 + time.time * coefs[i%coefs.length] + Math.floor(time.beat / 4)),
                        Math.cos(i * 3.7 + time.time * coefs[(i+1)%coefs.length]),
                        Math.sin(i * 9.8 + time.time * coefs[(i+2)%coefs.length] * Math.sin(i))
                    ]);
                }

                ctx.globalAlpha = time.progress;
                ctx.strokeStyle = 'white';
                ctx.lineWidth = Math.random() * 0.01;
                ctx.translate(w / 2, h / 2);
                ctx.scale(w, w);
                ctx.beginPath();
                var count = pts.length;
                var n = 0;
                for ( var i = 0; i < count; i++ ) {
                    var p0 = pts[i];
                    var p1 = pts[(i+1)%count];
                    var p2 = pts[(i+2)%count];
                    var p3 = pts[(i+3)%count];
                    for ( var t = 0; t <= 1; t += 0.005) {
                        var x = spline(p0[0], p1[0], p2[0], p3[0], t);
                        var y = spline(p0[1], p1[1], p2[1], p3[1], t);
                        var z = spline(p0[2], p1[2], p2[2], p3[2], t);
                        x += Math.sin(n) * 0.1;
                        y += Math.cos(n) * 0.1;
                        z += Math.sin(n * 0.78) * 0.1;
                        n += 0.01 * i;
                        x /= 3 - z;
                        y /= 3 - z;
                        ctx.lineTo(x, y);
                    }
                }
                ctx.closePath();
                ctx.stroke();


                scenes.noise.level = 0.25 + time.progress*0.75;
            }
        },
        end:{
            start: 'hasoc.end',
            length: 8 * 4,
            update: function(time) {
                ctx.fillStyle = 'hsl(0,100%,' + (100 - time.progress * 50) + '%)';
                ctx.fillRect(0, 0, w, h);
                ctx.drawImage(Math.random() * time.progress > 0.5 ? images.supercell : images.end, 0, 0);
                scenes.noise.level = 1 - time.progress * 0.75;
                this.filters.brightness = Math.sin(time.time * 0.2) * 0.5 + 0.5;
            }
        },
        death: {
            start: 'end.end',
            length: 1,
            update: function() {
                scenes.noise.level = 0;
            }
        },
        noise: {
            start: 0,
            length: 76 * 4,
            update: function(time) {
                ctx.globalAlpha = this.level;
                ctx.globalCompositeOperation = 'lighter';
                ctx.translate(Math.random() * w, Math.random() * h);
                ctx.drawImage(images.noise, 0, 0);
                ctx.drawImage(images.noise, -w, 0);
                ctx.drawImage(images.noise, 0, -h);
                ctx.drawImage(images.noise, -w, -h);
                this.filters.blur = Math.random() * 8;
                //this.filters.brightness = 0.95 + Math.random() * 0.1;
                this.filters.grayscale = ( Math.random() < 0.3 ) ? Math.random() : 0;
                //this.filters.contrast = 1 + Math.random() * 0.1;
            },
            level: 0.05
        }
    };

    // Calcula marcajele de timp
    var beatLength = 60000.0 / bpm;
    var demoEndTime = 0;

    for ( var i in scenes ) {
        var s = scenes[i];
        var time = (s.start || 0) * beatLength;
        if ( typeof s.start == 'string') {
            var m = s.start.match(/([^\.]+)\.end/);
            if (m) {
                time = scenes[m[1]].endTime;
            }
        }
        s.startTime = time;
        s.endTime = time + s.length * beatLength;
        demoEndTime = Math.max(demoEndTime, s.endTime);
    }

    // Buclă
    var running = false;

    function update() {
        var time = music.currentTime * 1000;
        var beat = time / beatLength;

        if ( time >= demoEndTime ) {
            running = false;
            console.log('end')
            return;
        }

        ctx.fillStyle = 'black';
        ctx.fillRect(0, 0, w, h);

        var filters = {};
        for ( var i in scenes) {
            var scene = scenes[i];
            if ( scene.startTime <= time && scene.endTime > time) {
                scene.filters = {};
                ctx.save();
                scene.update({
                    time: time,
                    beat: beat,
                    progress: (time - scene.startTime) / (scene.endTime - scene.startTime)
                });
                ctx.restore();
                for ( var i in scene.filters ) {
                    filters[i] = scene.filters[i];
                }
            }
        }

        applyFilters(filters);
        requestAnimationFrame(update);
    }

    function demoReady() {
        document.getElementById('loading').style.display = 'none';
        var dialog = document.getElementById('dialog');
        dialog.style.display = 'block';
        document.getElementById('play').onclick = function() {
            dialog.style.display = 'none';
            canvas.style.display = 'inline';
            resize();
            startDemo();
        }
    }
    
    function startDemo() {
        running = true;
        music.play();
        music.currentTime = 0;//scenes.end.startTime / 1000;
        requestAnimationFrame(update);
    }

    // Resurse de sarcină
    var loadCounter = 0;
    function registerResource(res, eventName) {
        loadCounter++;
        res['on'+(eventName||'load')] = function loadHandler() {
            loadCounter--;
            if ( loadCounter == 0 ) {
                demoReady();
            }
        }
    }

    for ( var i in resources.images ) {
        var img = new Image();
        registerResource(img);
        img.src = 'files/' + resources.images[i];
        images[i] = img;
    }

    music = new Audio();
    registerResource(music, 'canplay');
    music.src = 'files/' + resources.music;

    //
    function createCanvas(init) {
        var canvas = document.createElement('canvas');
        canvas.width = w;
        canvas.height = h;
        if (init) {
          init(canvas);
        }
        return canvas;
    }
    
    function value(values, keyTimes, time) {
        var idx = 0;
        for ( var i in keyTimes ) {
            if (time >= keyTimes[i]) {
                idx = parseInt(i);
            } else {
                break;
            }
        }
        var v1 = values[idx], v2 = values[idx+1];
        var t1 = keyTimes[idx], t2 = keyTimes[idx+1];
        if (typeof v2 == 'undefined') {
            v2 = v1;
            t2 = t1;
        }

        return v1 + (time - t1) / (t2 - t1) * (v2 - v1);
    }
    
    function linear(p0, p1, t) {
      return p0 + (p1 - p0) * t;
    }

    function spline(p0, p1, p2, p3, t) {
        var t2 = t * t;
        return  0.5 *( (2 * p1) +
                (-p0 + p2) * t +
                (2*p0 - 5*p1 + 4*p2 - p3) * t2 +
                (-p0 + 3*p1- 3*p2 + p3) * t2 * t);
    }
};

