#version 330 core

// Input vertex data, different for all executions of this shader.
in vec3 vertexPosition_modelspace;
in vec2 vertexUV;
in vec3 vertexnormal;

// Output data ; will be interpolated for each fragment.
out vec3 normal;
out vec3 position;

// Values that stay constant for the whole mesh.
uniform mat4 MVP;
uniform mat4 M;
uniform mat4 V;

void main(){
	// Output position of the vertex, in clip space : MVP * position
	vec4 temppos =  MVP * vec4(vertexPosition_modelspace, 1.0);
	position = (V * M * vec4(vertexPosition_modelspace, 1.0)).xyz + 1e-8 * vec3(vertexUV, 0.0);
	gl_Position = temppos;
	
	// Vertex normal shiat.
	normal = normalize( (transpose(inverse(V * M)) * vec4(normalize(vertexnormal), 0.0)).xyz );
}

