#version 120

varying vec2 UV;

uniform sampler2D fp_texture;
uniform float time;
const vec2 iResolution = vec2(1024.0, 768.0);

vec4 glow(vec2 coord) {
#define KERNELW 32
    vec4 summa = vec4(0.0);
    float pixelx = 2.0 / iResolution.x;
    float pixely = 2.0 / iResolution.y;
    float sumnum = 0.0;
    for ( int x = -KERNELW/2; x <= KERNELW/2; x++) {
        for ( int y = -KERNELW/2; y <= KERNELW/2; y++ ) {
            float weight = exp(-float(x * x + y * y) / (KERNELW / 0.2));
            vec2 uuz = coord + vec2(pixelx * x, pixely * y);
            summa += weight * texture2D(fp_texture, uuz);
            sumnum += weight;
        }
    }
    return vec4(3.0*summa.xyz, summa.a) / sumnum;
}

void main(){
    vec4 gcolor = texture2D( fp_texture, UV ) + glow(UV);
    gl_FragColor = vec4(min(vec3(1.0), gcolor.rgb), 1.0);
}