uniform vec3 cameraposition;

varying float cameraDistance;
varying vec2 texturecoord;

void main(void)
{
	vec4 transformedPosition = gl_ModelViewMatrix * gl_Vertex;
	
	texturecoord = gl_MultiTexCoord0.st;
	cameraDistance = length(vec4(cameraposition, 1.0) - gl_Vertex);

	gl_Position = ftransform();
}