/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.values;

import cml.kickass.exceptions.AsmError;
import cml.kickass.exceptions.AsmException;
import cml.kickass.function.Function;
import cml.kickass.function.table.FunctionTable;
import cml.kickass.function.table.StdFunctionTable;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.libraries.MathLibrary;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.InvalidValue;
import cml.kickass.values.LockableValue;
import cml.kickass.values.NullValue;
import cml.kickass.values.NumberValue;
import cml.kickass.values.Value;
import cml.tools.tuples.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class ListValue
extends LockableValue {
    public static ListValue invalid = new ListValue();
    private ArrayList<Value> list = new ArrayList();
    boolean hasInvalidContent = false;
    static FunctionTable functions = new StdFunctionTable(ListValue.getStandardFunctions());

    private ListValue() {
        this.setInvalid();
    }

    public ListValue(int n) {
        for (int i = 0; i < n; ++i) {
            this.list.add(NullValue.instance);
        }
    }

    @Override
    public String getType() {
        return "List";
    }

    @Override
    public boolean hasInvalidContent() {
        return this.hasInvalidContent;
    }

    public void add(Value value) {
        this.list.add(value);
        if (value.isInvalidOrInvalidContent()) {
            this.hasInvalidContent = true;
        }
    }

    public void add(Value ... valueArray) {
        for (Value value : valueArray) {
            this.add(value);
        }
    }

    @Override
    public Object getRepresentation(int n) throws AsmException {
        if (n == RP_STRINGVALUE) {
            if (this.isInvalid()) {
                return "<<Invalid List>>";
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[");
            for (int i = 0; i < this.list.size(); ++i) {
                if (i != 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(this.list.get(i).getString(null));
            }
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
        if (n == RP_LISTVALUE) {
            return this.list;
        }
        return null;
    }

    void checkForOutOfBound(int n, DebugInfo debugInfo) throws AsmException {
        if (n < 0 || this.list.size() <= n) {
            throw new AsmError("Index out of bound : " + n, debugInfo);
        }
    }

    @Override
    public FunctionTable getFunctions() {
        return functions;
    }

    @Override
    public void lock(DebugInfo debugInfo) {
        if (this.isLocked) {
            return;
        }
        if (this.isInvalidOrInvalidContent()) {
            return;
        }
        this.isLocked = true;
        for (Value value : this.list) {
            value.lock(debugInfo);
        }
    }

    static {
        functions.add(new Function("add", null, null, true){

            @Override
            public Value execute(Value[] valueArray, EvaluationState evaluationState, DebugInfo debugInfo) {
                ListValue listValue = (ListValue)valueArray[0];
                listValue.ensureNotLocked(debugInfo);
                if (listValue.isInvalid()) {
                    return listValue;
                }
                for (int i = 1; i < valueArray.length; ++i) {
                    listValue.add(valueArray[i]);
                }
                return listValue;
            }
        });
        functions.add(new ListValueStateFunction("get", InvalidValue.instance){

            @Override
            protected Value f(ListValue listValue, Value value, EvaluationState evaluationState, DebugInfo debugInfo) {
                if (value.isInvalid()) {
                    return InvalidValue.instance;
                }
                int n = value.getInt(debugInfo);
                listValue.checkForOutOfBound(n, debugInfo);
                Value value2 = (Value)listValue.list.get(n);
                if (value2.isInvalid()) {
                    evaluationState.setInvalidSideEffectsDuringFunctionEvaluation();
                }
                return (Value)listValue.list.get(n);
            }
        });
        functions.add(new ListValueX2Function("set", null){

            @Override
            protected Value f(ListValue listValue, Value value, Value value2, DebugInfo debugInfo) {
                listValue.ensureNotLocked(debugInfo);
                if (value.isInvalid()) {
                    listValue.setInvalid();
                    return listValue;
                }
                int n = value.getInt(debugInfo);
                listValue.checkForOutOfBound(n, debugInfo);
                listValue.list.set(n, value2);
                if (value2.isInvalidOrInvalidContent()) {
                    listValue.hasInvalidContent = true;
                }
                return listValue;
            }
        });
        functions.add(new ListValueFunction("remove", null){

            @Override
            protected Value f(ListValue listValue, Value value, DebugInfo debugInfo) {
                listValue.ensureNotLocked(debugInfo);
                if (value.isInvalid()) {
                    listValue.setInvalid();
                    return listValue;
                }
                int n = value.getInt(debugInfo);
                listValue.checkForOutOfBound(n, debugInfo);
                listValue.list.remove(n);
                return listValue;
            }
        });
        functions.add(new ListFunction("size", NumberValue.invalid){

            @Override
            protected Value f(ListValue listValue, DebugInfo debugInfo) {
                return new NumberValue(listValue.list.size());
            }
        });
        functions.add(new ListFunction("shuffle", null){

            @Override
            protected Value f(ListValue listValue, DebugInfo debugInfo) {
                listValue.ensureNotLocked(debugInfo);
                Collections.shuffle(listValue.list, MathLibrary.getRandomGenerator());
                return listValue;
            }
        });
        functions.add(new ListFunction("reverse", null){

            @Override
            protected Value f(ListValue listValue, DebugInfo debugInfo) {
                listValue.ensureNotLocked(debugInfo);
                Collections.reverse(listValue.list);
                return listValue;
            }
        });
        functions.add(new ListFunction("sort", null){

            @Override
            protected Value f(ListValue listValue, DebugInfo debugInfo) {
                listValue.ensureNotLocked(debugInfo);
                ArrayList<Pair<Double, Value>> arrayList = new ArrayList<Pair<Double, Value>>();
                for (Value value : listValue.list) {
                    Double d = (Double)value.getRepresentation(Value.RP_DOUBLEVALUE);
                    Double d2 = d != null ? d : Double.MAX_VALUE;
                    arrayList.add(new Pair<Double, Value>(d2, value));
                }
                Comparator<Pair<Double, Value>> comparator = new Comparator<Pair<Double, Value>>(){

                    @Override
                    public int compare(Pair<Double, Value> pair, Pair<Double, Value> pair2) {
                        return Double.compare(pair.getA(), pair2.getA());
                    }
                };
                Collections.sort(arrayList, comparator);
                for (int i = 0; i < arrayList.size(); ++i) {
                    listValue.list.set(i, ((Pair)arrayList.get(i)).getB());
                }
                return listValue;
            }
        });
    }

    static abstract class ListValueX2Function
    extends Function {
        public ListValueX2Function(String string, Value value) {
            super(string, 3, value, true);
        }

        @Override
        public Value execute(Value[] valueArray, EvaluationState evaluationState, DebugInfo debugInfo) {
            ListValue listValue = (ListValue)valueArray[0];
            if (listValue.isInvalid()) {
                return this.getInvalidResult(valueArray);
            }
            return this.f((ListValue)valueArray[0], valueArray[1], valueArray[2], debugInfo);
        }

        protected abstract Value f(ListValue var1, Value var2, Value var3, DebugInfo var4);
    }

    static abstract class ListValueStateFunction
    extends Function {
        public ListValueStateFunction(String string, Value value) {
            super(string, 2, value, true);
        }

        @Override
        public Value execute(Value[] valueArray, EvaluationState evaluationState, DebugInfo debugInfo) {
            ListValue listValue = (ListValue)valueArray[0];
            if (listValue.isInvalid()) {
                return this.getInvalidResult(valueArray);
            }
            return this.f((ListValue)valueArray[0], valueArray[1], evaluationState, debugInfo);
        }

        protected abstract Value f(ListValue var1, Value var2, EvaluationState var3, DebugInfo var4);
    }

    static abstract class ListValueFunction
    extends Function {
        public ListValueFunction(String string, Value value) {
            super(string, 2, value, true);
        }

        @Override
        public Value execute(Value[] valueArray, EvaluationState evaluationState, DebugInfo debugInfo) {
            ListValue listValue = (ListValue)valueArray[0];
            if (listValue.isInvalid()) {
                return this.getInvalidResult(valueArray);
            }
            return this.f((ListValue)valueArray[0], valueArray[1], debugInfo);
        }

        protected abstract Value f(ListValue var1, Value var2, DebugInfo var3);
    }

    static abstract class ListFunction
    extends Function {
        public ListFunction(String string, Value value) {
            super(string, 1, value);
        }

        @Override
        public Value execute(Value[] valueArray, EvaluationState evaluationState, DebugInfo debugInfo) {
            return this.f((ListValue)valueArray[0], debugInfo);
        }

        protected abstract Value f(ListValue var1, DebugInfo var2);
    }
}

