/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.misc;

import cml.kickass.constant.Constant;
import cml.kickass.misc.ArgTypes;
import cml.kickass.values.NumberValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MnemonicTable {
    private static HashMap<String, int[]> mnemonics = new HashMap();
    private static Object[] mnemonicsData = new Object[]{new Object[]{"ora", new int[]{-1, 9, 5, 21, -1, 1, 17, 13, 29, 25, -1, -1}}, new Object[]{"and", new int[]{-1, 41, 37, 53, -1, 33, 49, 45, 61, 57, -1, -1}}, new Object[]{"eor", new int[]{-1, 73, 69, 85, -1, 65, 81, 77, 93, 89, -1, -1}}, new Object[]{"adc", new int[]{-1, 105, 101, 117, -1, 97, 113, 109, 125, 121, -1, -1}}, new Object[]{"sbc", new int[]{-1, 233, 229, 245, -1, 225, 241, 237, 253, 249, -1, -1}}, new Object[]{"cmp", new int[]{-1, 201, 197, 213, -1, 193, 209, 205, 221, 217, -1, -1}}, new Object[]{"cpx", new int[]{-1, 224, 228, -1, -1, -1, -1, 236, -1, -1, -1, -1}}, new Object[]{"cpy", new int[]{-1, 192, 196, -1, -1, -1, -1, 204, -1, -1, -1, -1}}, new Object[]{"dec", new int[]{-1, -1, 198, 214, -1, -1, -1, 206, 222, -1, -1, -1}}, new Object[]{"dex", new int[]{202, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}}, new Object[]{"dey", new int[]{136, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}}, new Object[]{"inc", new int[]{-1, -1, 230, 246, -1, -1, -1, 238, 254, -1, -1, -1}}, new Object[]{"inx", new int[]{232, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}}, new Object[]{"iny", new int[]{200, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}}, new Object[]{"asl", new int[]{10, -1, 6, 22, -1, -1, -1, 14, 30, -1, -1, -1}}, new Object[]{"rol", new int[]{42, -1, 38, 54, -1, -1, -1, 46, 62, -1, -1, -1}}, new Object[]{"lsr", new int[]{74, -1, 70, 86, -1, -1, -1, 78, 94, -1, -1, -1}}, new Object[]{"ror", new int[]{106, -1, 102, 118, -1, -1, -1, 110, 126, -1, -1, -1}}, new Object[]{"lda", new int[]{-1, 169, 165, 181, -1, 161, 177, 173, 189, 185, -1, -1}}, new Object[]{"sta", new int[]{-1, -1, 133, 149, -1, 129, 145, 141, 157, 153, -1, -1}}, new Object[]{"ldx", new int[]{-1, 162, 166, -1, 182, -1, -1, 174, -1, 190, -1, -1}}, new Object[]{"stx", new int[]{-1, -1, 134, -1, 150, -1, -1, 142, -1, -1, -1, -1}}, new Object[]{"ldy", new int[]{-1, 160, 164, 180, -1, -1, -1, 172, 188, -1, -1, -1}}, new Object[]{"sty", new int[]{-1, -1, 132, 148, -1, -1, -1, 140, -1, -1, -1, -1}}, new Object[]{"tax", new int[]{170, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}}, new Object[]{"txa", new int[]{138, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}}, new Object[]{"tay", new int[]{168, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}}, new Object[]{"tya", new int[]{152, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}}, new Object[]{"tsx", new int[]{186, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}}, new Object[]{"txs", new int[]{154, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}}, new Object[]{"pla", new int[]{104, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}}, new Object[]{"pha", new int[]{72, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}}, new Object[]{"plp", new int[]{40, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}}, new Object[]{"php", new int[]{8, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}}, new Object[]{"bpl", new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 16}}, new Object[]{"bmi", new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 48}}, new Object[]{"bvc", new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 80}}, new Object[]{"bvs", new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 112}}, new Object[]{"bcc", new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 144}}, new Object[]{"bcs", new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 176}}, new Object[]{"bne", new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 208}}, new Object[]{"beq", new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 240}}, new Object[]{"brk", new int[]{0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}}, new Object[]{"rti", new int[]{64, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}}, new Object[]{"jsr", new int[]{-1, -1, -1, -1, -1, -1, -1, 32, -1, -1, -1, -1}}, new Object[]{"rts", new int[]{96, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}}, new Object[]{"jmp", new int[]{-1, -1, -1, -1, -1, -1, -1, 76, -1, -1, 108, -1}}, new Object[]{"bit", new int[]{-1, -1, 36, -1, -1, -1, -1, 44, -1, -1, -1, -1}}, new Object[]{"clc", new int[]{24, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}}, new Object[]{"sec", new int[]{56, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}}, new Object[]{"cld", new int[]{216, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}}, new Object[]{"sed", new int[]{248, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}}, new Object[]{"cli", new int[]{88, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}}, new Object[]{"sei", new int[]{120, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}}, new Object[]{"clv", new int[]{184, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}}, new Object[]{"nop", new int[]{234, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}}, new Object[]{"slo", new int[]{-1, -1, 7, 23, -1, 3, 19, 15, 31, 27, -1, -1}}, new Object[]{"rla", new int[]{-1, -1, 39, 55, -1, 35, 51, 47, 63, 59, -1, -1}}, new Object[]{"sre", new int[]{-1, -1, 71, 87, -1, 67, 83, 79, 95, 91, -1, -1}}, new Object[]{"rra", new int[]{-1, -1, 103, 119, -1, 99, 115, 111, 127, 123, -1, -1}}, new Object[]{"sax", new int[]{-1, -1, 135, -1, 151, 131, -1, 143, -1, -1, -1, -1}}, new Object[]{"lax", new int[]{-1, 171, 167, -1, 183, 163, 179, 175, -1, 191, -1, -1}}, new Object[]{"dcp", new int[]{-1, -1, 199, 215, -1, 195, 211, 207, 223, 219, -1, -1}}, new Object[]{"isc", new int[]{-1, -1, 231, 247, -1, 227, 243, 239, 255, 251, -1, -1}}, new Object[]{"anc", new int[]{-1, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}}, new Object[]{"anc2", new int[]{-1, 43, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}}, new Object[]{"alr", new int[]{-1, 75, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}}, new Object[]{"arr", new int[]{-1, 107, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}}, new Object[]{"xaa", new int[]{-1, 139, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}}, new Object[]{"axs", new int[]{-1, 203, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}}, new Object[]{"sbc2", new int[]{-1, 235, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}}, new Object[]{"ahx", new int[]{-1, -1, -1, -1, -1, -1, 147, -1, -1, 159, -1, -1}}, new Object[]{"shy", new int[]{-1, -1, -1, -1, -1, -1, -1, -1, 156, -1, -1, -1}}, new Object[]{"shx", new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, 158, -1, -1}}, new Object[]{"tas", new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, 155, -1, -1}}, new Object[]{"las", new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, 187, -1, -1}}, new Object[]{"sac", new int[]{-1, 50, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}}, new Object[]{"sir", new int[]{-1, 66, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}}, new Object[]{"bra", new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 18}}};

    public static int[] getPossibleModes(String string) {
        return mnemonics.get(string);
    }

    public static int getOpcode(String string, int n) {
        int[] nArray = MnemonicTable.getPossibleModes(string);
        if (nArray == null) {
            return -2;
        }
        return nArray[n];
    }

    public static boolean hasRelativeAdressMode(String string) {
        return MnemonicTable.getOpcode(string, 11) >= 0;
    }

    public static List<Constant> getOpcodeConstants() {
        ArrayList<Constant> arrayList = new ArrayList<Constant>();
        for (Map.Entry<String, int[]> entry : mnemonics.entrySet()) {
            String string = entry.getKey();
            int[] nArray = entry.getValue();
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] < 0) continue;
                String string2 = string.toUpperCase();
                if (i > 0) {
                    string2 = string2 + "_" + ArgTypes.typeToShortString(i);
                }
                arrayList.add(new Constant(string2, new NumberValue(nArray[i])));
            }
        }
        return arrayList;
    }

    public static int getCommandSize(int n) {
        for (Map.Entry<String, int[]> entry : mnemonics.entrySet()) {
            int[] nArray = entry.getValue();
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] != n) continue;
                return ArgTypes.getSize(i) + 1;
            }
        }
        return 0;
    }

    public static void main(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : mnemonics.keySet()) {
            int n;
            for (n = 0; n < arrayList.size() && string.compareTo((String)arrayList.get(n)) > 0; ++n) {
            }
            arrayList.add(n, string);
        }
        Iterator<String> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string;
            String string2 = string = iterator.next();
            int[] nArray = mnemonics.get(string);
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                String string3 = Integer.toHexString(n);
                if (string3.length() == 1) {
                    string3 = "0" + string3;
                }
                string3 = "$" + string3;
                string2 = string2 + "," + (n < 0 ? "" : string3);
            }
            System.out.println(string2);
        }
    }

    static {
        for (int i = 0; i < mnemonicsData.length; ++i) {
            Object[] objectArray = (Object[])mnemonicsData[i];
            String string = (String)objectArray[0];
            int[] nArray = (int[])objectArray[1];
            if (mnemonics.containsKey(string)) {
                System.out.println("Error! - duplicate mnemonic :" + string);
            }
            mnemonics.put((String)objectArray[0], (int[])objectArray[1]);
        }
    }
}

