/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.expressions;

import cml.kickass.exceptions.AsmError;
import cml.kickass.exceptions.AsmException;
import cml.kickass.expressions.ExprNode;
import cml.kickass.expressions.ExprTreeBuilder;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.lexvalues.DebugTokenValue;
import cml.kickass.sideeffect.SESymbolDeclaration;
import cml.kickass.state.EvaluationState;
import cml.kickass.state.scope.SymbolScope;
import cml.kickass.values.ConstantReferenceValue;
import cml.kickass.values.NullValue;
import cml.kickass.values.NumberValue;
import cml.kickass.values.Value;
import java.util.List;

public class EnumDeclaration
extends ExprNode {
    private List<Object[]> enumList;

    public EnumDeclaration(List<Object[]> list, DebugInfo debugInfo) {
        super(debugInfo);
        this.enumList = list;
    }

    @Override
    public Value evaluate(EvaluationState evaluationState) throws AsmException {
        SymbolScope symbolScope = evaluationState.getCurrentScope().getSymbols();
        int n = 0;
        for (Object[] objectArray : this.enumList) {
            Value value;
            DebugInfo debugInfo = ((DebugTokenValue)objectArray[0]).getDebugInfo();
            String string = ((DebugTokenValue)objectArray[0]).getString();
            ExprNode exprNode = (ExprNode)objectArray[1];
            if (symbolScope.getLocalDefinedEntities().get(string) != null) {
                throw new AsmError("The symbol '" + string + "' is already defined", debugInfo);
            }
            if (exprNode == null) {
                value = new NumberValue(n++);
            } else {
                value = exprNode.evaluate(evaluationState).deReference();
                if (value.isInvalidOrInvalidContent()) {
                    evaluationState.setInvalidSideEffectsDuringFunctionEvaluation();
                }
            }
            ConstantReferenceValue constantReferenceValue = new ConstantReferenceValue(value);
            symbolScope.put(string, constantReferenceValue);
            if (evaluationState.getFunctionsMode()) continue;
            SESymbolDeclaration sESymbolDeclaration = new SESymbolDeclaration(string, constantReferenceValue, value);
            evaluationState.addSideEffect(sESymbolDeclaration);
        }
        return NullValue.instance;
    }

    @Override
    public ExprTreeBuilder toNodeTreeString(ExprTreeBuilder exprTreeBuilder) {
        boolean bl = true;
        String string = "";
        for (Object[] objectArray : this.enumList) {
            if (!bl) {
                string = string + ",";
            }
            String string2 = ((DebugTokenValue)objectArray[0]).getString();
            string = string + string2;
        }
        exprTreeBuilder.addNode("EnumDec", string, new ExprNode[0]);
        return exprTreeBuilder;
    }
}

