/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.directives.asmmode;

import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.NodeTreeBuilder;
import cml.kickass.asmnode.output.reciever.OutputReciever;
import cml.kickass.directives.asmmode.AsmDirective;
import cml.kickass.exceptions.AsmError;
import cml.kickass.expressions.ExprNode;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.Value;

public class PseudoPCDirective
extends AsmDirective {
    private ExprNode orgAddressExpr;
    private AsmNode body;
    boolean functionsEvalOk = false;

    public PseudoPCDirective(ExprNode exprNode, AsmNode asmNode, DebugInfo debugInfo) {
        super(debugInfo);
        this.orgAddressExpr = exprNode;
        this.body = asmNode;
    }

    @Override
    public AsmNode copy() {
        return new PseudoPCDirective(this.orgAddressExpr, this.body.copy(), this.debug);
    }

    @Override
    public boolean isFinished() {
        return this.functionsEvalOk && this.body.isFinished();
    }

    @Override
    public void deliverOutput(OutputReciever outputReciever) {
        this.body.deliverOutput(outputReciever);
    }

    @Override
    public AsmNode parse(EvaluationState evaluationState) {
        if (evaluationState.getPseudoPcMode()) {
            throw new AsmError("You cant nest pseudo pc directives", this.debug);
        }
        evaluationState.clearFunctionSideOutput();
        Value value = this.orgAddressExpr.evaluate(evaluationState);
        if (value.isInvalid()) {
            this.invalidatePcAndReturnThis(evaluationState);
        }
        int n = value.getInt(this.debug);
        Integer n2 = evaluationState.getMemoryPosition();
        evaluationState.setMemoryPosition(n);
        evaluationState.setRealMemoryPosition(n2);
        evaluationState.setPseudoPcMode(true);
        this.body = this.body.parse(evaluationState);
        evaluationState.setPseudoPcMode(false);
        evaluationState.setMemoryPosition(evaluationState.getRealMemoryPosition());
        this.functionsEvalOk = !evaluationState.getErrorOrInvalidSideEffectsDuringFunctionEvaluation();
        return this;
    }

    @Override
    public AsmNode registerMetaDefinitions(EvaluationState evaluationState) {
        this.body = this.body.registerMetaDefinitions(evaluationState);
        return this;
    }

    @Override
    public AsmNode preParse(EvaluationState evaluationState) {
        this.body = this.body.preParse(evaluationState);
        return this;
    }

    @Override
    public NodeTreeBuilder toNodeTreeString(NodeTreeBuilder nodeTreeBuilder) {
        nodeTreeBuilder.enterNode("PseudoPc", this.debug);
        nodeTreeBuilder.addArg(null, this.orgAddressExpr);
        nodeTreeBuilder.addArg(null, this.body);
        nodeTreeBuilder.exitNode();
        return nodeTreeBuilder;
    }
}

