/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.directives.asmmode;

import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.NodeTreeBuilder;
import cml.kickass.asmnode.metanodes.ScopeNode;
import cml.kickass.asmnode.output.SideEffectOnlyOutput;
import cml.kickass.asmnode.output.reciever.CodeCollectorOutputReciever;
import cml.kickass.directives.asmmode.AsmDirective;
import cml.kickass.expressions.ExprNode;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.misc.MemoryBlock;
import cml.kickass.misc.StringTool;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.Value;
import cml.log.Log;

public class AssertCodeDirective
extends AsmDirective {
    Log log = new Log("AssertCodeDirective");
    ExprNode msgExpr;
    AsmNode resultNode;
    AsmNode expectedNode;
    DebugInfo debug;

    public AssertCodeDirective(ExprNode exprNode, AsmNode asmNode, AsmNode asmNode2, DebugInfo debugInfo) {
        super(debugInfo);
        this.msgExpr = exprNode;
        this.resultNode = new ScopeNode(asmNode);
        this.expectedNode = new ScopeNode(asmNode2);
    }

    @Override
    public AsmNode copy() {
        return this;
    }

    @Override
    public AsmNode registerMetaDefinitions(EvaluationState evaluationState) {
        this.resultNode = this.resultNode.registerMetaDefinitions(evaluationState);
        this.expectedNode = this.expectedNode.registerMetaDefinitions(evaluationState);
        return this;
    }

    @Override
    public AsmNode preParse(EvaluationState evaluationState) {
        this.resultNode = this.resultNode.preParse(evaluationState);
        this.expectedNode = this.expectedNode.preParse(evaluationState);
        return this;
    }

    @Override
    public AsmNode parse(EvaluationState evaluationState) {
        boolean bl;
        Integer n = evaluationState.getMemoryPosition();
        evaluationState.setMemoryPositionWithoutSideEffect(8192);
        this.resultNode = this.resultNode.parse(evaluationState);
        evaluationState.setMemoryPositionWithoutSideEffect(8192);
        this.expectedNode = this.expectedNode.parse(evaluationState);
        evaluationState.setMemoryPositionWithoutSideEffect(n);
        evaluationState.clearFunctionSideOutput();
        Value value = this.msgExpr.evaluate(evaluationState);
        boolean bl2 = evaluationState.getErrorOrInvalidSideEffectsDuringFunctionEvaluation();
        boolean bl3 = bl = this.resultNode.isFinished() && this.expectedNode.isFinished() && !bl2;
        if (!bl) {
            return this;
        }
        String string = value.getString(this.debug);
        CodeCollectorOutputReciever codeCollectorOutputReciever = new CodeCollectorOutputReciever(8192, evaluationState.getMaxMemoryAddress());
        CodeCollectorOutputReciever codeCollectorOutputReciever2 = new CodeCollectorOutputReciever(8192, evaluationState.getMaxMemoryAddress());
        this.resultNode.deliverOutput(codeCollectorOutputReciever);
        this.expectedNode.deliverOutput(codeCollectorOutputReciever2);
        boolean bl4 = codeCollectorOutputReciever.codeIsEqual(codeCollectorOutputReciever2);
        String string2 = bl4 ? string + " -- OK. | " + this.codeToString(codeCollectorOutputReciever) : string + " -- FAILED! | " + this.codeToString(codeCollectorOutputReciever) + "  -- " + this.codeToString(codeCollectorOutputReciever2);
        evaluationState.addTextOutput(string2);
        evaluationState.getAssertManager().madeAssert(!bl4);
        return new SideEffectOnlyOutput(evaluationState.getFunctionSideOutput());
    }

    private String codeToString(CodeCollectorOutputReciever codeCollectorOutputReciever) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (MemoryBlock memoryBlock : codeCollectorOutputReciever.getMemoryBlocks()) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append("; ");
            }
            stringBuffer.append(StringTool.toHexString(memoryBlock.getStartAdress(), 4));
            stringBuffer.append(":");
            boolean bl2 = true;
            for (byte by : memoryBlock.getMemory()) {
                if (bl2) {
                    bl2 = false;
                } else {
                    stringBuffer.append(",");
                }
                stringBuffer.append(StringTool.toHexString(by, 2));
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public NodeTreeBuilder toNodeTreeString(NodeTreeBuilder nodeTreeBuilder) {
        nodeTreeBuilder.enterNode("AssertCode", this.debug);
        nodeTreeBuilder.addArg("msg", this.msgExpr);
        nodeTreeBuilder.addArg("result", this.resultNode);
        nodeTreeBuilder.addArg("expected", this.expectedNode);
        nodeTreeBuilder.exitNode();
        return nodeTreeBuilder;
    }
}

