/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.directives.asmandfunctionmode;

import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.NodeTreeBuilder;
import cml.kickass.asmnode.metanodes.ScopeNode;
import cml.kickass.directives.Directive;
import cml.kickass.directives.Label;
import cml.kickass.directives.LabelConnector;
import cml.kickass.exceptions.NotImplementedException;
import cml.kickass.state.EvaluationState;
import cml.kickass.state.scope.StdScope;
import cml.kickass.values.NameSpaceValue;

public class ScopeDirective
extends Directive
implements LabelConnector {
    private AsmNode body;
    private String nameSpaceId;
    private boolean nameSpaceAlsoLabel;

    public ScopeDirective(AsmNode asmNode) {
        this(asmNode, null);
    }

    public ScopeDirective(AsmNode asmNode, String string) {
        super(null);
        this.body = asmNode;
        this.nameSpaceId = string;
        this.nameSpaceAlsoLabel = false;
    }

    private ScopeDirective(AsmNode asmNode, String string, boolean bl) {
        super(null);
        this.body = asmNode;
        this.nameSpaceId = string;
        this.nameSpaceAlsoLabel = bl;
    }

    @Override
    public boolean connectToLabel(Label label) {
        if (this.nameSpaceId != null) {
            return false;
        }
        this.nameSpaceId = label.getName();
        this.nameSpaceAlsoLabel = true;
        return true;
    }

    @Override
    public AsmNode preParse(EvaluationState evaluationState) {
        NameSpaceValue nameSpaceValue = this.nameSpaceId == null ? null : new NameSpaceValue(this.nameSpaceId, this.nameSpaceAlsoLabel);
        return new ScopeNode(this.body, nameSpaceValue, false, this.debug).preParse(evaluationState);
    }

    @Override
    public AsmNode registerMetaDefinitions(EvaluationState evaluationState) {
        this.body.registerMetaDefinitions(evaluationState);
        return this;
    }

    @Override
    public AsmNode parse(EvaluationState evaluationState) {
        throw NotImplementedException.intance;
    }

    @Override
    public AsmNode copy() {
        return new ScopeDirective(this.body.copy(), this.nameSpaceId, this.nameSpaceAlsoLabel);
    }

    @Override
    public void functionParse(EvaluationState evaluationState) {
        StdScope stdScope = new StdScope(evaluationState.getCurrentScope(), false);
        evaluationState.setCurrentScope(stdScope);
        this.body.functionParse(evaluationState);
        evaluationState.setCurrentScope(stdScope.getParrent());
    }

    @Override
    public NodeTreeBuilder toNodeTreeString(NodeTreeBuilder nodeTreeBuilder) {
        nodeTreeBuilder.enterNode("ScopeDirective", this.debug);
        nodeTreeBuilder.addArg("nameSpace", "" + this.nameSpaceId);
        nodeTreeBuilder.addArg(null, this.body);
        nodeTreeBuilder.exitNode();
        return nodeTreeBuilder;
    }
}

