/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.directives.asmandfunctionmode;

import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.NodeTreeBuilder;
import cml.kickass.asmnode.output.SideEffectOnlyOutput;
import cml.kickass.directives.Directive;
import cml.kickass.expressions.ExprNode;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.Value;

public class PrintDirective
extends Directive {
    private ExprNode msgExpr;

    public PrintDirective(ExprNode exprNode, DebugInfo debugInfo) {
        super(debugInfo);
        this.msgExpr = exprNode;
    }

    @Override
    public AsmNode copy() {
        return this;
    }

    @Override
    public AsmNode parse(EvaluationState evaluationState) {
        evaluationState.clearFunctionSideOutput();
        Value value = this.msgExpr.evaluate(evaluationState);
        if (evaluationState.getErrorOrInvalidSideEffectsDuringFunctionEvaluation()) {
            return this;
        }
        String string = value.getString(this.debug);
        evaluationState.addTextOutput(string);
        return new SideEffectOnlyOutput(evaluationState.getFunctionSideOutput());
    }

    @Override
    public void functionParse(EvaluationState evaluationState) {
        Value value = this.msgExpr.evaluate(evaluationState);
        if (value.isInvalid()) {
            return;
        }
        String string = value.getString(this.debug);
        evaluationState.addTextOutput(string);
    }

    @Override
    public NodeTreeBuilder toNodeTreeString(NodeTreeBuilder nodeTreeBuilder) {
        nodeTreeBuilder.addNode("Print", this.debug, this.msgExpr);
        return nodeTreeBuilder;
    }
}

