/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass;

import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.metanodes.AsmNodeList;
import cml.kickass.exceptions.AsmError;
import cml.kickass.exceptions.AsmException;
import cml.kickass.lexandparse.Lexer;
import cml.kickass.lexandparse.parser;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.misc.MemoryBlock;
import cml.kickass.state.EvaluationState;
import cml.tools.FileTool;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class AssemblerToolbox {
    public static AsmNode loadAndLex(String string, EvaluationState evaluationState, DebugInfo debugInfo) throws AsmException {
        InputStream inputStream = evaluationState.openFile(string, debugInfo);
        return AssemblerToolbox.loadAndLex(inputStream, string, evaluationState, debugInfo);
    }

    public static AsmNode loadAndLex(File file, EvaluationState evaluationState, DebugInfo debugInfo) throws AsmException {
        String string = FileTool.getCanonicalFilePath(file);
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        }
        catch (Exception exception) {
            throw new AsmError("Can't create inputstream from file " + FileTool.getCanonicalFilePath(file), debugInfo);
        }
        return AssemblerToolbox.loadAndLex(bufferedInputStream, string, evaluationState, debugInfo);
    }

    public static AsmNode loadAndLex(InputStream inputStream, String string, EvaluationState evaluationState, DebugInfo debugInfo) throws AsmException {
        Lexer lexer = new Lexer(inputStream);
        lexer.setInputfilenameForDebugging(string);
        lexer.setParrentDebugInfo(debugInfo);
        parser parser2 = new parser(lexer);
        AsmNodeList asmNodeList = null;
        try {
            List list = (List)parser2.parse().value;
            asmNodeList = new AsmNodeList(list);
        }
        catch (Exception exception) {
            throw new AsmError(exception.getMessage(), null);
        }
        return asmNodeList;
    }

    public static String printMemoryBlocks(List<MemoryBlock> list) {
        ArrayList<MemoryBlock> arrayList = new ArrayList<MemoryBlock>();
        arrayList.addAll(list);
        Comparator<MemoryBlock> comparator = new Comparator<MemoryBlock>(){

            @Override
            public int compare(MemoryBlock memoryBlock, MemoryBlock memoryBlock2) {
                int n;
                int n2 = memoryBlock.getStartAdress();
                if (n2 < (n = memoryBlock2.getStartAdress())) {
                    return -1;
                }
                if (n2 == n) {
                    return 0;
                }
                return 1;
            }
        };
        Collections.sort(arrayList, comparator);
        String string = "Memory Map\n----------\n";
        for (MemoryBlock memoryBlock : arrayList) {
            int n = memoryBlock.getStartAdress();
            int n2 = memoryBlock.getStartAdress() + memoryBlock.getSize() - 1;
            String string2 = memoryBlock.isVirtual() ? "*" : "";
            string = string + string2 + AssemblerToolbox.intToHexString(n) + "-" + AssemblerToolbox.intToHexString(n2) + " " + memoryBlock.getName() + "\n";
        }
        return string;
    }

    private static String intToHexString(int n) {
        String string = Integer.toHexString(n);
        int n2 = Math.max(4 - string.length(), 0);
        for (int i = 0; i < n2; ++i) {
            string = "0" + string;
        }
        return "$" + string;
    }
}

