/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.values;

import cml.kickass.exceptions.AsmError;
import cml.kickass.exceptions.AsmException;
import cml.kickass.function.Function;
import cml.kickass.function.table.FunctionTable;
import cml.kickass.function.table.StdFunctionTable;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.LockableValue;
import cml.kickass.values.NumberValue;
import cml.kickass.values.Value;
import cml.kickass.values.VectorValue;

public class MatrixValue
extends LockableValue {
    public static MatrixValue invalid = new MatrixValue();
    private double[][] entries = new double[4][4];
    static FunctionTable functions = new StdFunctionTable(MatrixValue.getStandardFunctions());

    private MatrixValue() {
        this.setInvalid();
    }

    public MatrixValue(double[][] dArray) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.entries[i][j] = dArray[i][j];
            }
        }
    }

    @Override
    public String getType() {
        return "Matrix";
    }

    @Override
    public Object getRepresentation(int n) throws AsmException {
        if (n == RP_MATRIXVALUE) {
            return this.entries;
        }
        if (n == RP_STRINGVALUE) {
            if (this.isInvalid()) {
                return "<<Invalid StringMatrix>>";
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[");
            for (int i = 0; i < 4; ++i) {
                if (i != 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append("[");
                for (int j = 0; j < 4; ++j) {
                    if (j != 0) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(this.entries[i][j]);
                }
                stringBuffer.append("]");
            }
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
        return null;
    }

    @Override
    public FunctionTable getFunctions() {
        return functions;
    }

    private Value matrixMatrixMul(double[][] dArray, double[][] dArray2) {
        double[][] dArray3 = new double[4][4];
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 4; ++k) {
                    double[] dArray4 = dArray3[j];
                    int n = i;
                    dArray4[n] = dArray4[n] + dArray[j][k] * dArray2[k][i];
                }
            }
        }
        return new MatrixValue(dArray3);
    }

    private Value matrixVectorMul(double[][] dArray, double[] dArray2) {
        double[] dArray3 = new double[]{dArray2[0] * dArray[0][0] + dArray2[1] * dArray[0][1] + dArray2[2] * dArray[0][2] + dArray[0][3], dArray2[0] * dArray[1][0] + dArray2[1] * dArray[1][1] + dArray2[2] * dArray[1][2] + dArray[1][3], dArray2[0] * dArray[2][0] + dArray2[1] * dArray[2][1] + dArray2[2] * dArray[2][2] + dArray[2][3], dArray2[0] * dArray[3][0] + dArray2[1] * dArray[3][1] + dArray2[2] * dArray[3][2] + dArray[3][3]};
        return new VectorValue(dArray3[0] / dArray3[3], dArray3[1] / dArray3[3], dArray3[2] / dArray3[3]);
    }

    private void outOfBoundCheck(int n, int n2, DebugInfo debugInfo) throws AsmException {
        if (n < 0 || 4 <= n || n2 < 0 || 4 <= n2) {
            throw new AsmError("Index out of bound (" + n + "," + n2 + ")", debugInfo);
        }
    }

    @Override
    public void lock(DebugInfo debugInfo) {
        this.isLocked = true;
    }

    @Override
    public String toString() {
        return "MatrixValue";
    }

    static {
        functions.add(new MatrixFunction("get", 3, NumberValue.invalid, false){

            @Override
            protected Value f(MatrixValue matrixValue, DebugInfo debugInfo, Value ... valueArray) {
                int n = valueArray[1].getInt(debugInfo);
                int n2 = valueArray[2].getInt(debugInfo);
                matrixValue.outOfBoundCheck(n, n2, debugInfo);
                return new NumberValue(matrixValue.entries[n][n2]);
            }
        });
        functions.add(new MatrixFunction("set", 4, null, true){

            @Override
            protected Value f(MatrixValue matrixValue, DebugInfo debugInfo, Value ... valueArray) {
                matrixValue.ensureNotLocked(debugInfo);
                if (valueArray[1].isInvalid() || valueArray[2].isInvalid() || valueArray[3].isInvalid()) {
                    matrixValue.setInvalid();
                    return matrixValue;
                }
                int n = valueArray[1].getInt(debugInfo);
                int n2 = valueArray[2].getInt(debugInfo);
                double d = valueArray[3].getDouble(debugInfo);
                matrixValue.outOfBoundCheck(n, n2, debugInfo);
                ((MatrixValue)matrixValue).entries[n][n2] = d;
                return matrixValue;
            }
        });
        functions.add(new MatrixFunction("*", 2, invalid, false){

            @Override
            protected Value f(MatrixValue matrixValue, DebugInfo debugInfo, Value ... valueArray) {
                double[][] dArray = (double[][])valueArray[1].getRepresentation(Value.RP_MATRIXVALUE);
                if (dArray != null) {
                    return matrixValue.matrixMatrixMul(matrixValue.entries, dArray);
                }
                double[] dArray2 = (double[])valueArray[1].getRepresentation(Value.RP_VECTORVALUE);
                if (dArray2 != null) {
                    return matrixValue.matrixVectorMul(matrixValue.entries, dArray2);
                }
                throw new AsmError("Cant multiply a matrix with an object of type " + valueArray[0].getType(), debugInfo);
            }
        });
    }

    static abstract class MatrixFunction
    extends Function {
        public MatrixFunction(String string, Integer n, Value value, boolean bl) {
            super(string, n, value, bl);
        }

        @Override
        public Value execute(Value[] valueArray, EvaluationState evaluationState, DebugInfo debugInfo) {
            MatrixValue matrixValue = (MatrixValue)valueArray[0];
            if (matrixValue.isInvalid()) {
                return this.getInvalidResult(valueArray);
            }
            return this.f(matrixValue, debugInfo, valueArray);
        }

        protected abstract Value f(MatrixValue var1, DebugInfo var2, Value ... var3);
    }
}

