/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.misc;

import cml.kickass.state.scope.Scope;
import cml.kickass.values.LabelReferenceValue;
import cml.kickass.values.NameSpaceValue;
import cml.kickass.values.SymbolScopeValue;
import cml.log.Log;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;

public class SymbolFile {
    private static String newline = System.getProperty("line.separator");
    private static Log log = new Log("SymbolFile");
    private Scope rootScope;
    private String indent = "  ";

    public SymbolFile(Scope scope) {
        this.rootScope = scope;
    }

    public void writeFile(String string) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
            this.writeScope(0, this.rootScope, bufferedWriter);
            ((Writer)bufferedWriter).close();
        }
        catch (IOException iOException) {
            log.error("IO error while writing symbol file '" + string + "':" + iOException.getMessage());
        }
        catch (Exception exception) {
            log.error("Internal error while writing symbol file '" + string + "'. Contact the author");
            exception.printStackTrace(System.out);
        }
    }

    private void writeScope(int n, Scope scope, Writer writer) throws IOException {
        String string = this.getIndent(n);
        Map map = scope.getSymbols().getLocalDefinedEntities();
        for (Map.Entry entry : map.entrySet()) {
            boolean bl;
            boolean bl2;
            String string2 = entry.getKey();
            SymbolScopeValue symbolScopeValue = (SymbolScopeValue)entry.getValue();
            if (symbolScopeValue.getClass().equals(LabelReferenceValue.class)) {
                String string3 = Integer.toHexString(symbolScopeValue.getInt(null));
                writer.write(string + ".label " + string2 + "=$" + string3 + newline);
            }
            boolean bl3 = bl2 = symbolScopeValue instanceof NameSpaceValue && !((NameSpaceValue)symbolScopeValue).isAlsoLabel();
            if (bl2) {
                writer.write(string + ".namespace " + string2 + " {" + newline);
                this.writeScope(n + 1, ((NameSpaceValue)symbolScopeValue).getScope(), writer);
                writer.write(string + "}" + newline);
            }
            if (!(bl = symbolScopeValue instanceof NameSpaceValue && ((NameSpaceValue)symbolScopeValue).isAlsoLabel())) continue;
            String string4 = Integer.toHexString(symbolScopeValue.getInt(null));
            writer.write(string + ".label " + string2 + "=$" + string4 + " {" + newline);
            this.writeScope(n + 1, ((NameSpaceValue)symbolScopeValue).getScope(), writer);
            writer.write(string + "}" + newline);
        }
    }

    private String getIndent(int n) {
        String string = "";
        while (n > 0) {
            string = string + this.indent;
            --n;
        }
        return string;
    }
}

