/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.directives.asmmode;

import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.NodeTreeBuilder;
import cml.kickass.asmnode.output.EmptyOutput;
import cml.kickass.directives.Directive;
import cml.kickass.directives.asmmode.AsmDirective;
import cml.kickass.exceptions.AsmError;
import cml.kickass.exceptions.NotImplementedException;
import cml.kickass.expressions.ExprNode;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;

public class PluginDirective
extends AsmDirective {
    private String className;

    public PluginDirective(String string, DebugInfo debugInfo) {
        super(debugInfo);
        this.className = string;
    }

    @Override
    public Directive copy() {
        return this;
    }

    @Override
    public AsmNode registerMetaDefinitions(EvaluationState evaluationState) {
        Object obj;
        Class<?> clazz;
        try {
            clazz = Class.forName(this.className);
        }
        catch (Exception exception) {
            throw new AsmError("Can't find class for plugin", this.debug);
        }
        try {
            obj = clazz.newInstance();
        }
        catch (Exception exception) {
            throw new AsmError("Plugin found but can't instantiate it", this.debug);
        }
        evaluationState.addPlugin(obj);
        return EmptyOutput.instance;
    }

    @Override
    public AsmNode parse(EvaluationState evaluationState) {
        throw NotImplementedException.intance;
    }

    @Override
    public NodeTreeBuilder toNodeTreeString(NodeTreeBuilder nodeTreeBuilder) {
        nodeTreeBuilder.addNode("Plugin", this.debug, this.className, new ExprNode[0]);
        return nodeTreeBuilder;
    }
}

