/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.directives.asmandfunctionmode;

import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.NodeTreeBuilder;
import cml.kickass.asmnode.metanodes.ScopeNode;
import cml.kickass.asmnode.output.EmptyOutput;
import cml.kickass.directives.Directive;
import cml.kickass.exceptions.AsmError;
import cml.kickass.expressions.ExprNode;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.sideeffect.SideEffect;
import cml.kickass.state.EvaluationState;
import cml.kickass.state.FunctionSideOutput;
import cml.kickass.values.Value;

public class IfDirective
extends Directive {
    private ExprNode conditionExpr;
    private AsmNode trueBody;
    private AsmNode falseBody;
    private boolean conditionDone = false;
    private FunctionSideOutput conditionSideEffects;
    private AsmNode scopeNode;

    public IfDirective(ExprNode exprNode, AsmNode asmNode, AsmNode asmNode2, DebugInfo debugInfo) {
        super(debugInfo);
        this.conditionExpr = exprNode;
        this.trueBody = asmNode;
        this.falseBody = asmNode2;
    }

    @Override
    public AsmNode copy() {
        AsmNode asmNode = this.falseBody == null ? null : this.falseBody.copy();
        return new IfDirective(this.conditionExpr, this.trueBody.copy(), asmNode, this.debug);
    }

    @Override
    public AsmNode parse(EvaluationState evaluationState) {
        AsmNode asmNode = null;
        if (this.conditionDone) {
            this.execSideEffects(this.conditionSideEffects, evaluationState);
        } else {
            evaluationState.clearFunctionSideOutput();
            Value value = this.conditionExpr.evaluate(evaluationState);
            if (value.isInvalid()) {
                throw new AsmError("The condition must be able to evaluate in first parse", this.debug);
            }
            AsmNode asmNode2 = asmNode = value.getBoolean(this.debug) ? this.trueBody : this.falseBody;
            if (!evaluationState.getErrorOrInvalidSideEffectsDuringFunctionEvaluation()) {
                this.conditionDone = true;
                this.conditionSideEffects = evaluationState.getFunctionSideOutput();
            }
        }
        if (this.scopeNode == null) {
            this.scopeNode = asmNode == null ? EmptyOutput.instance : new ScopeNode(asmNode);
            this.scopeNode = this.scopeNode.preParse(evaluationState);
        }
        this.scopeNode = this.scopeNode.parse(evaluationState);
        if (this.conditionDone && this.conditionSideEffects == null) {
            return this.scopeNode;
        }
        return this;
    }

    private void execSideEffects(FunctionSideOutput functionSideOutput, EvaluationState evaluationState) {
        if (functionSideOutput != null) {
            for (SideEffect sideEffect : functionSideOutput.getSideEffects()) {
                sideEffect.evaluate(evaluationState, this.debug);
            }
        }
    }

    @Override
    public void functionParse(EvaluationState evaluationState) {
        Value value = this.conditionExpr.evaluate(evaluationState);
        if (value.isInvalid()) {
            throw new AsmError("Invalid/Unresolved condition value. Can't resolve if", this.debug);
        }
        boolean bl = value.getBoolean(this.debug);
        if (bl) {
            this.trueBody.functionParse(evaluationState);
        } else if (this.falseBody != null) {
            this.falseBody.functionParse(evaluationState);
        }
    }

    @Override
    public boolean isFinished() {
        return this.scopeNode != null && this.scopeNode.isFinished();
    }

    @Override
    public NodeTreeBuilder toNodeTreeString(NodeTreeBuilder nodeTreeBuilder) {
        nodeTreeBuilder.enterNode("If", this.debug);
        nodeTreeBuilder.addArg(null, this.conditionExpr);
        nodeTreeBuilder.addArg("true", this.trueBody);
        if (this.falseBody != null) {
            nodeTreeBuilder.addArg("false", this.falseBody);
        }
        nodeTreeBuilder.exitNode();
        return nodeTreeBuilder;
    }
}

