/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.directives.asmandfunctionmode;

import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.NodeTreeBuilder;
import cml.kickass.asmnode.output.SideEffectOnlyOutput;
import cml.kickass.directives.Directive;
import cml.kickass.exceptions.AsmError;
import cml.kickass.expressions.ExprNode;
import cml.kickass.function.Function;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.Value;
import cml.log.Log;

public class AssertDirective
extends Directive {
    Log log = new Log("AssertDirective");
    ExprNode msgExpr;
    ExprNode resultExpr;
    ExprNode expectedExpr;

    public AssertDirective(ExprNode exprNode, ExprNode exprNode2, ExprNode exprNode3, DebugInfo debugInfo) {
        super(debugInfo);
        this.msgExpr = exprNode;
        this.resultExpr = exprNode2;
        this.expectedExpr = exprNode3;
    }

    @Override
    public AsmNode parse(EvaluationState evaluationState) {
        String string;
        boolean bl;
        evaluationState.clearFunctionSideOutput();
        Value value = this.msgExpr.evaluate(evaluationState);
        Value value2 = this.resultExpr.evaluate(evaluationState);
        Value value3 = this.expectedExpr.evaluate(evaluationState);
        boolean bl2 = bl = value2.isInvalidOrInvalidContent() || value3.isInvalidOrInvalidContent();
        if (bl || evaluationState.getErrorOrInvalidSideEffectsDuringFunctionEvaluation()) {
            return this;
        }
        Value[] valueArray = new Value[]{value2.deReference(), value3.deReference()};
        Function function = value2.getFunctions().get("==", valueArray, this.debug);
        boolean bl3 = function.execute(valueArray, evaluationState, this.debug).getBoolean(this.debug);
        String string2 = string = bl3 ? "" : " -- ERROR IN ASSERTION!!!";
        if (evaluationState.getErrorDuringFunctionEvaluation()) {
            return this;
        }
        evaluationState.addTextOutput(value.getString(this.debug) + "=" + value2.getString(this.debug) + " (" + value3.getString(this.debug) + ")" + string);
        evaluationState.getAssertManager().madeAssert(!bl3);
        return new SideEffectOnlyOutput(evaluationState.getFunctionSideOutput());
    }

    @Override
    public AsmNode copy() {
        return this;
    }

    @Override
    public void functionParse(EvaluationState evaluationState) {
        throw new AsmError("You cannot use the assert directive in function mode", this.debug);
    }

    @Override
    public NodeTreeBuilder toNodeTreeString(NodeTreeBuilder nodeTreeBuilder) {
        nodeTreeBuilder.enterNode("Assert", this.debug);
        nodeTreeBuilder.addArg(null, this.msgExpr);
        nodeTreeBuilder.addArg("result", this.resultExpr);
        nodeTreeBuilder.addArg("expected", this.expectedExpr);
        nodeTreeBuilder.exitNode();
        return nodeTreeBuilder;
    }
}

