/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.asmnode.metanodes;

import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.NodeTreeBuilder;
import cml.kickass.asmnode.output.reciever.OutputReciever;
import cml.kickass.exceptions.ShouldNotBeHereException;
import cml.kickass.state.EvaluationState;
import java.io.File;

public class SetCurrentDirectoryNode
extends AsmNode {
    private File directory;
    private AsmNode body;

    public SetCurrentDirectoryNode(File file, AsmNode asmNode) {
        this.directory = file;
        this.body = asmNode;
    }

    @Override
    public AsmNode copy() {
        return new SetCurrentDirectoryNode(this.directory, this.body);
    }

    @Override
    public void deliverOutput(OutputReciever outputReciever) {
        this.body.deliverOutput(outputReciever);
    }

    @Override
    public void functionParse(EvaluationState evaluationState) {
        throw ShouldNotBeHereException.instance;
    }

    @Override
    public boolean isFinished() {
        return this.body.isFinished();
    }

    @Override
    public AsmNode parse(EvaluationState evaluationState) {
        File file = evaluationState.getCurrentDirectory();
        evaluationState.setCurrentDirectory(this.directory);
        this.body.parse(evaluationState);
        evaluationState.setCurrentDirectory(file);
        return this;
    }

    @Override
    public AsmNode preParse(EvaluationState evaluationState) {
        File file = evaluationState.getCurrentDirectory();
        evaluationState.setCurrentDirectory(this.directory);
        this.body.preParse(evaluationState);
        evaluationState.setCurrentDirectory(file);
        return this;
    }

    @Override
    public AsmNode registerMetaDefinitions(EvaluationState evaluationState) {
        File file = evaluationState.getCurrentDirectory();
        evaluationState.setCurrentDirectory(this.directory);
        this.body.registerMetaDefinitions(evaluationState);
        evaluationState.setCurrentDirectory(file);
        return this;
    }

    @Override
    public NodeTreeBuilder toNodeTreeString(NodeTreeBuilder nodeTreeBuilder) {
        nodeTreeBuilder.enterNode("SetCurrentDirectory", null);
        nodeTreeBuilder.addArg(null, this.directory.getPath());
        nodeTreeBuilder.addArg(null, this.body);
        nodeTreeBuilder.exitNode();
        return nodeTreeBuilder;
    }
}

