/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.asmnode.metanodes;

import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.NodeTreeBuilder;
import cml.kickass.asmnode.metanodes.ScopeNode;
import cml.kickass.asmnode.output.reciever.OutputReciever;
import cml.kickass.exceptions.ShouldNotBeHereException;
import cml.kickass.expressions.ExprNode;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;
import cml.kickass.state.FunctionSideOutput;
import cml.kickass.state.scope.SymbolScope;
import cml.kickass.values.NameSpaceValue;
import cml.kickass.values.SymbolScopeValue;
import cml.kickass.values.Value;
import cml.kickass.values.VariableReferenceValue;
import cml.tools.tuples.Pair;
import java.util.List;

public class ArgumentAssignmentNode
extends AsmNode {
    private List<String> names;
    private List<ExprNode> argumentExprs;
    private AsmNode body;
    private DebugInfo debug;
    private Value defaultValue;
    private boolean assingmentOk;
    private Pair<SymbolScopeValue, FunctionSideOutput>[] parameterEvaluationResults;
    private ScopeNode bodyScopeNode;

    public ArgumentAssignmentNode(List<String> list, List<ExprNode> list2, AsmNode asmNode, Value value, NameSpaceValue nameSpaceValue, DebugInfo debugInfo) {
        this.names = list;
        this.argumentExprs = list2;
        this.bodyScopeNode = new ScopeNode(asmNode, nameSpaceValue, true, debugInfo);
        this.body = this.bodyScopeNode;
        this.debug = debugInfo;
        this.defaultValue = value;
        this.parameterEvaluationResults = new Pair[list.size()];
    }

    @Override
    public AsmNode copy() {
        throw ShouldNotBeHereException.instance;
    }

    @Override
    public void deliverOutput(OutputReciever outputReciever) {
        this.body.deliverOutput(outputReciever);
    }

    @Override
    public void functionParse(EvaluationState evaluationState) {
        throw ShouldNotBeHereException.instance;
    }

    @Override
    public boolean isFinished() {
        return this.assingmentOk && this.body.isFinished();
    }

    @Override
    public AsmNode preParse(EvaluationState evaluationState) {
        this.body = this.body.preParse(evaluationState);
        return this;
    }

    @Override
    public AsmNode parse(EvaluationState evaluationState) {
        SymbolScope symbolScope = this.bodyScopeNode.getOrNewScope(evaluationState).getSymbols();
        boolean bl = true;
        for (int i = 0; i < this.names.size(); ++i) {
            SymbolScopeValue symbolScopeValue;
            String string = this.names.get(i);
            Pair<SymbolScopeValue, FunctionSideOutput> pair = this.parameterEvaluationResults[i];
            if (pair != null) {
                this.parseSideOutput(pair.getB(), evaluationState);
                symbolScopeValue = pair.getA();
            } else {
                boolean bl2;
                evaluationState.clearFunctionSideOutput();
                Value value = this.argumentExprs.size() <= i ? this.defaultValue : this.argumentExprs.get(i).evaluate(evaluationState);
                symbolScopeValue = new VariableReferenceValue(value);
                boolean bl3 = bl2 = !evaluationState.getErrorOrInvalidSideEffectsDuringFunctionEvaluation();
                if (bl2 && value.isLocked() && !value.isInvalidOrInvalidContent()) {
                    this.parameterEvaluationResults[i] = new Pair<SymbolScopeValue, FunctionSideOutput>(symbolScopeValue, evaluationState.getFunctionSideOutput());
                }
                bl &= !evaluationState.getErrorDuringFunctionEvaluation();
            }
            symbolScope.put(string, symbolScopeValue);
        }
        this.assingmentOk = bl;
        this.body = this.body.parse(evaluationState);
        return this;
    }

    @Override
    public AsmNode registerMetaDefinitions(EvaluationState evaluationState) {
        return this;
    }

    @Override
    public NodeTreeBuilder toNodeTreeString(NodeTreeBuilder nodeTreeBuilder) {
        nodeTreeBuilder.enterNode("ArgumentAssigment", this.debug);
        nodeTreeBuilder.addArg("defaultValue", "" + this.defaultValue);
        nodeTreeBuilder.addArg(null, this.body);
        for (int i = 0; i < this.names.size(); ++i) {
            String string = this.names.get(i);
            nodeTreeBuilder.addArg("name" + (i + 1), string);
            Pair<SymbolScopeValue, FunctionSideOutput> pair = this.parameterEvaluationResults[i];
            if (pair != null) {
                nodeTreeBuilder.addArg("value" + (i + 1), pair.getA().getNodeTreeString());
                continue;
            }
            if (this.argumentExprs.size() <= i) {
                nodeTreeBuilder.addArg("value" + i, this.defaultValue);
                continue;
            }
            nodeTreeBuilder.addArg("value" + (i + 1), this.argumentExprs.get(i));
        }
        nodeTreeBuilder.exitNode();
        return nodeTreeBuilder;
    }
}

