/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass;

import cml.kickass.AssemblerToolbox;
import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.NodeTreeBuilder;
import cml.kickass.asmnode.metanodes.AsmNodeList;
import cml.kickass.asmnode.output.reciever.MainOutputReciever;
import cml.kickass.constant.Constant;
import cml.kickass.exceptions.AsmError;
import cml.kickass.function.Function;
import cml.kickass.libraries.Library;
import cml.kickass.libraries.MathLibrary;
import cml.kickass.libraries.MiscLibrary;
import cml.kickass.libraries.MnemonicsLibrary;
import cml.kickass.libraries.PrintLibrary;
import cml.kickass.libraries.StdConstructorLibrary;
import cml.kickass.libraries.VectorLibrary;
import cml.kickass.misc.C64File;
import cml.kickass.misc.MemoryBlock;
import cml.kickass.misc.SymbolFile;
import cml.kickass.misc.ViceSymbolFile;
import cml.kickass.state.AssertManager;
import cml.kickass.state.EvaluationState;
import cml.kickass.state.scope.SymbolScope;
import cml.kickass.values.ConstantReferenceValue;
import cml.kickass.values.HashtableValue;
import cml.kickass.values.Value;
import cml.log.Log;
import cml.tools.Timer;
import cml.tools.tuples.Pair;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class KickAssembler {
    private static final String AUTO_INCLUDED_FILE = "/include/autoinclude.asm";
    private static final String CONFIG_FILE = "/KickAss.cfg";
    private static final String PLUGIN_FILE = "/KickAss.plugin";
    private static Log log = new Log("");

    public static void main(String[] stringArray) {
        stringArray = KickAssembler.getExtraArgs(stringArray);
        log.println("//------------------------------------------------------");
        log.println("//------------------------------------------------------");
        log.println("//      Kick Assembler v3.30 - (C)2013 Mads Nielsen     ");
        log.println("//------------------------------------------------------");
        log.println("//------------------------------------------------------");
        File file = new File(".");
        String string = null;
        ArrayList<File> arrayList = new ArrayList<File>();
        arrayList.add(file);
        Object object = null;
        boolean bl = false;
        boolean bl2 = false;
        String string2 = null;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = true;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = false;
        boolean bl11 = false;
        String string3 = null;
        int n = 65535;
        byte by = 0;
        boolean bl12 = false;
        boolean bl13 = false;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        OutputStreamWriter outputStreamWriter = null;
        EvaluationState evaluationState = new EvaluationState();
        ArrayList<Library> arrayList2 = new ArrayList<Library>();
        arrayList2.add(new MathLibrary());
        arrayList2.add(new PrintLibrary());
        arrayList2.add(new VectorLibrary());
        arrayList2.add(new StdConstructorLibrary());
        arrayList2.add(new MiscLibrary());
        arrayList2.add(new MnemonicsLibrary());
        KickAssembler.parsePluginFile(evaluationState);
        try {
            Object exception;
            Object object2;
            AssertManager assertManager;
            Object object6;
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (((String)(object6 = stringArray[n2++])).equalsIgnoreCase("-o")) {
                    KickAssembler.ensureArgument(n2, stringArray, "-o");
                    string = stringArray[n2++];
                    continue;
                }
                if (((String)object6).equalsIgnoreCase("-libdir")) {
                    KickAssembler.ensureArgument(n2, stringArray, "-libdir");
                    arrayList.add(new File(stringArray[n2++]));
                    continue;
                }
                if (((String)object6).equalsIgnoreCase("-execute")) {
                    KickAssembler.ensureArgument(n2, stringArray, "-execute");
                    string2 = stringArray[n2++];
                    continue;
                }
                if (((String)object6).equalsIgnoreCase("-showmem")) {
                    bl = true;
                    continue;
                }
                if (((String)object6).equalsIgnoreCase("-debug")) {
                    bl2 = true;
                    continue;
                }
                if (((String)object6).equalsIgnoreCase("-binfile")) {
                    bl12 = true;
                    continue;
                }
                if (((String)object6).equalsIgnoreCase("-dtv")) {
                    bl3 = true;
                    continue;
                }
                if (((String)object6).equalsIgnoreCase("-mbfiles")) {
                    bl11 = true;
                    continue;
                }
                if (((String)object6).equalsIgnoreCase("-time")) {
                    bl6 = true;
                    continue;
                }
                if (((String)object6).equalsIgnoreCase("-warningsoff")) {
                    bl5 = false;
                    continue;
                }
                if (((String)object6).equalsIgnoreCase("-fillbyte")) {
                    KickAssembler.ensureArgument(n2, stringArray, "-fillbyte");
                    try {
                        by = (byte)Integer.valueOf(stringArray[n2++]).intValue();
                    }
                    catch (Exception exception2) {
                        log.println("Invalid arg for -fillbyte: " + stringArray[n2 - 1]);
                    }
                    continue;
                }
                if (((String)object6).equalsIgnoreCase("-maxaddr")) {
                    KickAssembler.ensureArgument(n2, stringArray, "-maxaddr");
                    try {
                        n = Integer.valueOf(stringArray[n2++]);
                    }
                    catch (Exception exception3) {
                        log.println("Invalid arg for -maxaddr: " + stringArray[n2 - 1]);
                    }
                    continue;
                }
                if (((String)object6).equalsIgnoreCase("-aom")) {
                    bl4 = true;
                    continue;
                }
                if (((String)object6).equalsIgnoreCase("-vicesymbols")) {
                    bl7 = true;
                    continue;
                }
                if (((String)object6).equalsIgnoreCase("-symbolfile")) {
                    bl8 = true;
                    continue;
                }
                if (((String)object6).equalsIgnoreCase("-symbolfiledir")) {
                    KickAssembler.ensureArgument(n2, stringArray, "-symbolfiledir");
                    string3 = stringArray[n2++];
                    continue;
                }
                if (((String)object6).equalsIgnoreCase("-afo")) {
                    bl13 = true;
                    continue;
                }
                if (((String)object6).equalsIgnoreCase("-parsetree")) {
                    bl9 = true;
                    continue;
                }
                if (((String)object6).equalsIgnoreCase("-displaylibraries")) {
                    bl10 = true;
                    continue;
                }
                if (((String)object6).equalsIgnoreCase("-log")) {
                    KickAssembler.ensureArgument(n2, stringArray, "-log");
                    try {
                        log.addPrintStream(new PrintStream(new FileOutputStream(stringArray[n2++])));
                    }
                    catch (Exception exception4) {
                        log.println("Couldn't create log : " + exception4.getMessage());
                    }
                    continue;
                }
                if (((String)object6).charAt(0) == ':') {
                    KickAssembler.parseCommandLineVar((String)object6, hashMap);
                    continue;
                }
                if (object == null) {
                    object = object6;
                    continue;
                }
                log.println("Warning. Allready have an inputfile. Won't use '" + (String)object6 + "'");
            }
            if (bl10) {
                KickAssembler.displayLibraries(arrayList2);
                return;
            }
            Log.setDebugging(bl2);
            Log.setWarnings(bl5);
            C64File.allowOverlappingMemoryBlocks(bl4);
            evaluationState.setSourceLibraryPath(arrayList);
            evaluationState.setDtvMode(bl3);
            evaluationState.setMaxMemoryAddress(n);
            object6 = new HashtableValue().addStringValues(hashMap);
            ((HashtableValue)object6).lock(null);
            evaluationState.getSystemScope().getSymbols().putErrorIfExist("cmdLineVars", new ConstantReferenceValue((Value)object6), "ERROR!", null);
            for (Library library : arrayList2) {
                evaluationState.addLibrary(library);
            }
            if (object == null) {
                log.println("Error: No inputfile supplied.");
                return;
            }
            if (!new File((String)object).exists()) {
                log.println("Error: Inputfile '" + object + "' doesn't exist.");
                return;
            }
            Object object7 = object;
            int n3 = ((String)object7).lastIndexOf(46);
            if (n3 >= 0) {
                object7 = ((String)object7).substring(0, n3);
            }
            if (string == null) {
                String string4 = bl12 ? ".bin" : ".prg";
                string = (String)object7 + string4;
            }
            if (bl9) {
                outputStreamWriter = new FileWriter("parsetree_.txt");
            }
            long l = System.nanoTime();
            boolean bl14 = true;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("User Arguments: ");
            for (Map.Entry object52 : hashMap.entrySet()) {
                if (bl14) {
                    bl14 = false;
                } else {
                    stringBuffer.append(", ");
                }
                stringBuffer.append((String)object52.getKey() + "=" + (String)object52.getValue());
            }
            if (!bl14) {
                log.println(stringBuffer.toString());
            }
            log.println("parsing");
            AsmNodeList asmNodeList = new AsmNodeList();
            InputStream inputStream = new KickAssembler().getClass().getResourceAsStream(AUTO_INCLUDED_FILE);
            asmNodeList.add(AssemblerToolbox.loadAndLex(inputStream, AUTO_INCLUDED_FILE, evaluationState, null));
            File file2 = evaluationState.getFile((String)object, null);
            evaluationState.setCurrentDirectory(file2.getCanonicalFile().getParentFile());
            asmNodeList.add(AssemblerToolbox.loadAndLex((String)object, evaluationState, null));
            AsmNodeList asmNodeList2 = asmNodeList;
            if (bl9) {
                outputStreamWriter.append("*****  Init tree *****\n");
                outputStreamWriter.append(((AsmNode)asmNodeList2).toNodeTreeString(new NodeTreeBuilder()).toString());
                outputStreamWriter.append("\n");
            }
            do {
                evaluationState.prepareNewParse();
                log.println("flex pass " + evaluationState.getPassNo());
                if (evaluationState.getPassNo() == 1) {
                    ((AsmNode)asmNodeList2).registerMetaDefinitions(evaluationState);
                    ((AsmNode)asmNodeList2).preParse(evaluationState);
                    if (bl9) {
                        outputStreamWriter.append("\n*****  Parsetree after preparse *****\n");
                        outputStreamWriter.append(((AsmNode)asmNodeList2).toNodeTreeString(new NodeTreeBuilder()).toString());
                        outputStreamWriter.append("\n");
                    }
                }
                asmNodeList2 = ((AsmNode)asmNodeList2).parse(evaluationState);
                if (bl9) {
                    outputStreamWriter.append("\n*****  Parsetree after parse " + evaluationState.getPassNo() + " *****\n");
                    outputStreamWriter.append(((AsmNode)asmNodeList2).toNodeTreeString(new NodeTreeBuilder()).toString());
                    outputStreamWriter.append("\n");
                }
                if (evaluationState.getMadeMetaProgress() || ((AsmNode)asmNodeList2).isFinished()) continue;
                evaluationState.prepareNewParse();
                evaluationState.setFailOnInvalidValue(true);
                asmNodeList2 = ((AsmNode)asmNodeList2).parse(evaluationState);
                throw new AsmError("Made no progress and cant solve the program.. You should have gotten an error. Contact the author!", null);
            } while (!((AsmNode)asmNodeList2).isFinished());
            log.println("Output pass");
            MainOutputReciever mainOutputReciever = new MainOutputReciever(8192, bl13, evaluationState.getMaxMemoryAddress());
            ((AsmNode)asmNodeList2).deliverOutput(mainOutputReciever);
            mainOutputReciever.finish();
            long l2 = System.nanoTime() - l;
            if (bl6) {
                log.println("Assemble time = " + l2 / 1000000L + " ms");
            }
            Timer.printTimers();
            if (outputStreamWriter != null) {
                try {
                    outputStreamWriter.close();
                    outputStreamWriter = null;
                }
                catch (Exception assertManager2) {
                    // empty catch block
                }
            }
            if (bl) {
                log.println();
                log.println(AssemblerToolbox.printMemoryBlocks(mainOutputReciever.getMemoryBlocks()));
            }
            if ((assertManager = evaluationState.getAssertManager()).getNoOfAsserts() > 0) {
                log.println();
                object2 = assertManager.getNoOfFailedAsserts() == 0 ? " failed" : " FAILED!";
                log.println("Made " + assertManager.getNoOfAsserts() + " asserts , " + assertManager.getNoOfFailedAsserts() + (String)object2);
            }
            if (!bl11) {
                KickAssembler.writeC64File(string, mainOutputReciever.getMemoryBlocks(), by, bl12);
            } else {
                object2 = new HashMap();
                for (MemoryBlock memoryBlock : mainOutputReciever.getMemoryBlocks()) {
                    if (memoryBlock.isVirtual()) continue;
                    ArrayList<MemoryBlock> arrayList3 = (ArrayList<MemoryBlock>)object2.get(memoryBlock.getName());
                    if (arrayList3 == null) {
                        arrayList3 = new ArrayList<MemoryBlock>();
                        object2.put(memoryBlock.getName(), arrayList3);
                    }
                    arrayList3.add(memoryBlock);
                }
                exception = new String[]{".bin", ".prg"};
                Pair<String, String> pair = KickAssembler.findFilenameBaseAndPostfix(string, exception);
                for (String string4 : object2.keySet()) {
                    String string5 = pair.getA() + "_" + string4 + pair.getB();
                    List list = (List)object2.get(string4);
                    if (list.size() != 1) {
                        log.warn("" + list.size() + " blocks have the name '" + string4 + "'. They will be merged in the same file.");
                    }
                    KickAssembler.writeC64File(string5, list, by, bl12);
                }
            }
            if (bl7) {
                object2 = new File((String)object7).getName() + ".vs";
                exception = new File(string).getParent();
                String string6 = (exception == null ? "" : (String)exception + File.separator) + (String)object2;
                log.println("Writing Vice symbol file: " + string6);
                new ViceSymbolFile(evaluationState.getCurrentScope()).writeFile(string6);
            }
            if (bl8) {
                if (string3 == null) {
                    object2 = (String)object7 + ".sym";
                } else {
                    exception = new File((String)object7).getName() + ".sym";
                    object2 = string3 + File.separator + (String)exception;
                }
                log.println("Writing Symbol file: " + (String)object2);
                new SymbolFile(evaluationState.getCurrentScope()).writeFile((String)object2);
            }
            if (string2 != null) {
                object2 = string2 + " " + string;
                try {
                    Runtime.getRuntime().exec((String)object2);
                }
                catch (Exception exception5) {
                    log.error("Error while executing external program: " + exception5);
                }
            }
        }
        catch (Exception exception) {
            if (exception instanceof AsmError) {
                ((AsmError)exception).setCallStack(evaluationState.getCallStack());
            }
            if (outputStreamWriter != null) {
                try {
                    outputStreamWriter.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            log.error(exception);
            System.exit(1);
        }
    }

    static void parseCommandLineVar(String string, Map<String, String> map) {
        int n = string.indexOf(61);
        if (n < 0) {
            throw new AsmError("Can't parse user command line argument. Missing '='. " + string, null);
        }
        String string2 = string.substring(1, n);
        String string3 = string.substring(n + 1);
        if (string2.length() == 0) {
            throw new AsmError("Can't parse user command line argument. Invalid argument name. " + string, null);
        }
        if (string3.length() != 0 && string3.charAt(0) == '\"') {
            if (string3.charAt(string3.length() - 1) == '\"') {
                throw new AsmError("Unterminated '\"' in command line argument. " + string, null);
            }
            string3 = string3.substring(1, string3.length() - 2);
        }
        map.put(string2, string3);
    }

    private static void ensureArgument(int n, String[] stringArray, String string) {
        if (n >= stringArray.length) {
            log.println("Missing parameter for '" + string + "' option");
            System.exit(1);
        }
    }

    private static File openConfigFile(String string) {
        File file = null;
        try {
            File file2 = new File(KickAssembler.class.getProtectionDomain().getCodeSource().getLocation().toURI());
            if (!file2.isDirectory()) {
                file2 = file2.getParentFile();
            } else {
                boolean bl = KickAssembler.javaFileExist(file2, KickAssembler.class.getCanonicalName());
                if (bl) {
                    file2 = file2.getParentFile();
                }
            }
            file = new File(file2, string);
            if (!file.exists()) {
                return null;
            }
            return file;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String[] getExtraArgs(String[] stringArray) {
        String[] stringArray2;
        File file = KickAssembler.openConfigFile(CONFIG_FILE);
        if (file == null) {
            return stringArray;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String string;
            stringArray2 = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            while ((string = stringArray2.readLine()) != null) {
                KickAssembler.parseConfigLine(string, arrayList);
            }
        }
        catch (IOException iOException) {
            System.out.println("Error while reading config file (/KickAss.cfg): " + iOException.getMessage());
            System.exit(1);
        }
        for (String string : stringArray) {
            arrayList.add(string);
        }
        stringArray2 = new String[arrayList.size()];
        int n = 0;
        for (String string : arrayList) {
            stringArray2[n++] = string;
        }
        return stringArray2;
    }

    private static boolean javaFileExist(File file, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        File file2 = file;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (!stringTokenizer.hasMoreTokens()) {
                string2 = string2 + ".class";
            }
            if ((file2 = new File(file2, string2)).exists()) continue;
            return false;
        }
        return true;
    }

    private static void parseConfigLine(String string, List<String> list) {
        int n = string.indexOf(34);
        String string2 = n < 0 ? string : string.substring(0, n);
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        while (stringTokenizer.hasMoreTokens()) {
            list.add(stringTokenizer.nextToken());
        }
        int n2 = string.indexOf(34, n + 1);
        if (n2 < 0) {
            n2 = string.length();
        }
        if (n >= 0) {
            list.add(string.substring(n + 1, n2));
        }
        if (n2 + 1 < string.length()) {
            KickAssembler.parseConfigLine(string.substring(n2 + 1), list);
        }
    }

    private static void parsePluginFile(EvaluationState evaluationState) {
        File file = KickAssembler.openConfigFile(PLUGIN_FILE);
        if (file == null) {
            return;
        }
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            while ((string = bufferedReader.readLine()) != null) {
                if (string.startsWith("//")) continue;
                Object object = KickAssembler.createObjectOrNull(string);
                if (object == null) {
                    log.println("Error while parsing /KickAss.cfg. Coundn't find class or create object for pluging: " + string);
                    continue;
                }
                evaluationState.addPlugin(object);
            }
        }
        catch (IOException iOException) {
            System.out.println("Error while reading config file (/KickAss.cfg): " + iOException.getMessage());
            System.exit(1);
        }
    }

    private static Object createObjectOrNull(String string) {
        try {
            return Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static void displayLibraries(List<Library> list) {
        log.println("DEFAULT CONSTANTS:");
        for (Library library : list) {
            for (Constant object : library.getConstants()) {
                log.println(object.getName());
            }
        }
        log.println();
        log.println("DEFAULT FUNCTIONS:");
        for (Library library : list) {
            for (Function function : library.getFunctions()) {
                log.println(function.getName());
            }
        }
    }

    private static void writeC64File(String string, List<MemoryBlock> list, byte by, boolean bl) {
        C64File c64File = new C64File(list, by);
        log.println("Writing file: " + string);
        c64File.writeFile(string, bl);
    }

    private static void collectSymbols(SymbolScope symbolScope, List<String> list) {
        for (String string : symbolScope.getLocalDefinedEntities().keySet()) {
            list.add(string);
        }
        if (symbolScope.getParrent() != null) {
            KickAssembler.collectSymbols(symbolScope.getParrent(), list);
        }
    }

    private static Pair<String, String> findFilenameBaseAndPostfix(String string, String[] stringArray) {
        for (String string2 : stringArray) {
            if (!string.endsWith(string2)) continue;
            String string3 = string.substring(0, string.length() - string2.length());
            return new Pair<String, String>(string3, string2);
        }
        return new Pair<String, String>(string, "");
    }

    static {
        log.addPrintStream(System.out);
    }
}

