attribute vec3 position;
attribute vec3 normal;

uniform float seconds;
uniform mat4 worldToClip;
uniform mat4 worldToCam;
uniform mat4 objToWorld;

varying vec3 posvar, normvar, eye, lamp;

void main() {
	float s = 0.00314;
	vec4 opos = vec4(s * position, 1.0);
	vec4 wpos = objToWorld * opos;
	vec4 cpos = worldToCam * wpos;

	posvar = cpos.xyz;
	vec4 wnorm = objToWorld * vec4(normal, 0.0);
	normvar = (worldToCam * wnorm).xyz;
	eye = vec3(0.0);
	lamp = vec3((1.0 * vec4(seconds, 0.0, 1.0, 3.0)).xyz);
	
	gl_Position = worldToClip * wpos;
}
