import ctypes
import gl
import sys
import time

def deb(x):
	print >> sys.stderr, x
	sys.stderr.flush()

#ogl = ctypes.CDLL('libEGL.so')
ogl = ctypes.CDLL('libGLESv2.so')
glut = ctypes.CDLL('libglut.so')

eglint = ctypes.c_int

eglshort = ctypes.c_short

def eglints(L):
    """Converts a tuple to an array of eglints (would a pointer return be better?)"""
    return (eglint*len(L))(*L)

eglfloat = ctypes.c_float

argc = ctypes.c_int(1)
argv = (ctypes.c_char_p * 1)() # array of just one
argv[0] = 'nobody'
def init():
	glut.glutInit(ctypes.byref(argc), argv)

def disp():
	print "disp"
	ogl.glClear(gl.GL_COLOR_BUFFER_BIT | gl.GL_DEPTH_BUFFER_BIT)
	glut.glutSwapBuffers()
	time.sleep(0.02)

def resh(w, h):
	ogl.glViewport(0, 0, w, h)

def idle():
	print "idle"
	glut.glutPostRedisplay()
	time.sleep(0.02)

GLUT_RGBA = 0
GLUT_DOUBLE = 2
GLUT_DEPTH = 0x10

c_func_void = ctypes.CFUNCTYPE(None)
c_func_void_int_int = ctypes.CFUNCTYPE(None, ctypes.c_int, ctypes.c_int)
disp_c = c_func_void(disp)
resh_c = c_func_void_int_int(resh)
idle_c = c_func_void(idle)

def main():
	init()
	glut.glutInitDisplayMode(GLUT_RGBA | GLUT_DOUBLE | GLUT_DEPTH)
	glut.glutInitWindowSize(640, 480)
	glut.glutCreateWindow('Persdemo')
	glut.glutDisplayFunc(disp_c)
	glut.glutReshapeFunc(resh_c)
	glut.glutIdleFunc(idle_c)
	glut.glutMainLoop()

if __name__ == "__main__":
	main()
