import ctypes

opengl = ctypes.CDLL('libGL.so')
glut = ctypes.CDLL('libglut.so')

GLUT_RGBA = 0
GLUT_DOUBLE = 2
GLUT_DEPTH = 0x10

def gl():
	return opengl

def swap():
	glut.glutSwapBuffers()

def idle():
	glut.glutPostRedisplay()

appl = None

def reshape(w, h):
	opengl.glViewport(0, 0, w, h)
	appl.reshape(w, h)

c_func_void = ctypes.CFUNCTYPE(None)
c_func_void_int_int = ctypes.CFUNCTYPE(None, ctypes.c_int, ctypes.c_int)
idle_c = c_func_void(idle)

def init(title, w, h):
	argc = ctypes.c_int(1)
	argv = (ctypes.c_char_p * 1)() # array of just one
	argv[0] = 'a.out' # don't care
	glut.glutInit(ctypes.byref(argc), argv)

	glut.glutInitDisplayMode(GLUT_RGBA | GLUT_DOUBLE | GLUT_DEPTH)
	glut.glutInitWindowSize(w, h)
	glut.glutCreateWindow(title)
	glut.glutIdleFunc(idle_c)

def run(app):
	global disp_c, resh_c # ctypes doesn't hold these
	global appl
	disp_c = c_func_void(app.render)
	resh_c = c_func_void_int_int(reshape)
	clos_c = c_func_void(app.stats)
	glut.glutDisplayFunc(disp_c)
	glut.glutReshapeFunc(resh_c)
	glut.glutCloseFunc(clos_c)
	appl = app
	glut.glutMainLoop()
