/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.pngj;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.CRC32;
import jogamp.opengl.util.pngj.PngHelperInternal;
import jogamp.opengl.util.pngj.PngjBadCrcException;
import jogamp.opengl.util.pngj.PngjExceptionInternal;
import jogamp.opengl.util.pngj.chunks.ChunkHelper;

class PngIDatChunkInputStream
extends InputStream {
    private final InputStream inputStream;
    private final CRC32 crcEngine;
    private boolean checkCrc = true;
    private int lenLastChunk;
    private byte[] idLastChunk = new byte[4];
    private int toReadThisChunk = 0;
    private boolean ended = false;
    private long offset;
    List<IdatChunkInfo> foundChunksInfo = new ArrayList<IdatChunkInfo>();

    PngIDatChunkInputStream(InputStream inputStream, int n, long l) {
        this.offset = l;
        this.inputStream = inputStream;
        this.lenLastChunk = n;
        this.toReadThisChunk = n;
        System.arraycopy(ChunkHelper.b_IDAT, 0, this.idLastChunk, 0, 4);
        this.crcEngine = new CRC32();
        this.crcEngine.update(this.idLastChunk, 0, 4);
        this.foundChunksInfo.add(new IdatChunkInfo(this.lenLastChunk, l - 8L));
        if (this.lenLastChunk == 0) {
            this.endChunkGoForNext();
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    private void endChunkGoForNext() {
        do {
            int n = PngHelperInternal.readInt4(this.inputStream);
            this.offset += 4L;
            if (this.checkCrc) {
                int n2 = (int)this.crcEngine.getValue();
                if (this.lenLastChunk > 0 && n != n2) {
                    throw new PngjBadCrcException("error reading idat; offset: " + this.offset);
                }
                this.crcEngine.reset();
            }
            this.toReadThisChunk = this.lenLastChunk = PngHelperInternal.readInt4(this.inputStream);
            PngHelperInternal.readBytes(this.inputStream, this.idLastChunk, 0, 4);
            this.offset += 8L;
            boolean bl = this.ended = !Arrays.equals(this.idLastChunk, ChunkHelper.b_IDAT);
            if (this.ended) continue;
            this.foundChunksInfo.add(new IdatChunkInfo(this.lenLastChunk, this.offset - 8L));
            if (!this.checkCrc) continue;
            this.crcEngine.update(this.idLastChunk, 0, 4);
        } while (this.lenLastChunk == 0 && !this.ended);
    }

    void forceChunkEnd() {
        if (!this.ended) {
            byte[] byArray = new byte[this.toReadThisChunk];
            PngHelperInternal.readBytes(this.inputStream, byArray, 0, this.toReadThisChunk);
            if (this.checkCrc) {
                this.crcEngine.update(byArray, 0, this.toReadThisChunk);
            }
            this.endChunkGoForNext();
        }
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.ended) {
            return -1;
        }
        if (this.toReadThisChunk == 0) {
            throw new PngjExceptionInternal("this should not happen");
        }
        int n3 = this.inputStream.read(byArray, n, n2 >= this.toReadThisChunk ? this.toReadThisChunk : n2);
        if (n3 > 0) {
            if (this.checkCrc) {
                this.crcEngine.update(byArray, n, n3);
            }
            this.offset += (long)n3;
            this.toReadThisChunk -= n3;
        }
        if (this.toReadThisChunk == 0) {
            this.endChunkGoForNext();
        }
        return n3;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read() throws IOException {
        byte[] byArray = new byte[1];
        int n = this.read(byArray, 0, 1);
        return n < 0 ? -1 : byArray[0];
    }

    int getLenLastChunk() {
        return this.lenLastChunk;
    }

    byte[] getIdLastChunk() {
        return this.idLastChunk;
    }

    long getOffset() {
        return this.offset;
    }

    boolean isEnded() {
        return this.ended;
    }

    void disableCrcCheck() {
        this.checkCrc = false;
    }

    static class IdatChunkInfo {
        public final int len;
        public final long offset;

        private IdatChunkInfo(int n, long l) {
            this.len = n;
            this.offset = l;
        }
    }
}

