/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.DataInput;
import java.io.IOException;
import jogamp.graph.font.typecast.ot.table.DirectoryEntry;
import jogamp.graph.font.typecast.ot.table.Table;

public class PcltTable
implements Table {
    private DirectoryEntry de;
    private int version;
    private long fontNumber;
    private int pitch;
    private int xHeight;
    private int style;
    private int typeFamily;
    private int capHeight;
    private int symbolSet;
    private char[] typeface = new char[16];
    private short[] characterComplement = new short[8];
    private char[] fileName = new char[6];
    private short strokeWeight;
    private short widthType;
    private byte serifStyle;
    private byte reserved;

    protected PcltTable(DirectoryEntry directoryEntry, DataInput dataInput) throws IOException {
        int n;
        this.de = (DirectoryEntry)directoryEntry.clone();
        this.version = dataInput.readInt();
        this.fontNumber = dataInput.readInt();
        this.pitch = dataInput.readUnsignedShort();
        this.xHeight = dataInput.readUnsignedShort();
        this.style = dataInput.readUnsignedShort();
        this.typeFamily = dataInput.readUnsignedShort();
        this.capHeight = dataInput.readUnsignedShort();
        this.symbolSet = dataInput.readUnsignedShort();
        for (n = 0; n < 16; ++n) {
            this.typeface[n] = (char)dataInput.readUnsignedByte();
        }
        for (n = 0; n < 8; ++n) {
            this.characterComplement[n] = (short)dataInput.readUnsignedByte();
        }
        for (n = 0; n < 6; ++n) {
            this.fileName[n] = (char)dataInput.readUnsignedByte();
        }
        this.strokeWeight = (short)dataInput.readUnsignedByte();
        this.widthType = (short)dataInput.readUnsignedByte();
        this.serifStyle = dataInput.readByte();
        this.reserved = dataInput.readByte();
    }

    @Override
    public int getType() {
        return 1346587732;
    }

    public String toString() {
        return "'PCLT' Table - Printer Command Language Table\n---------------------------------------------" + "\n        version:             0x" + Integer.toHexString(this.version).toUpperCase() + "\n        fontNumber:          " + this.fontNumber + " (0x" + Long.toHexString(this.fontNumber).toUpperCase() + ")\n        pitch:               " + this.pitch + "\n        xHeight:             " + this.xHeight + "\n        style:               0x" + this.style + "\n        typeFamily:          0x" + (this.typeFamily >> 12) + " " + (this.typeFamily & 0xFFF) + "\n        capHeight:           " + this.capHeight + "\n        symbolSet:           " + this.symbolSet + "\n        typeFace:            " + new String(this.typeface) + "\n        characterComplement  0x" + Integer.toHexString(this.characterComplement[0]).toUpperCase() + "\n        fileName:            " + new String(this.fileName) + "\n        strokeWeight:        " + this.strokeWeight + "\n        widthType:           " + this.widthType + "\n        serifStyle:          " + this.serifStyle + "\n        reserved:            " + this.reserved;
    }

    @Override
    public DirectoryEntry getDirectoryEntry() {
        return this.de;
    }
}

