/*
 * Decompiled with CFR 0.152.
 */
import ddf.minim.AudioPlayer;
import ddf.minim.Minim;
import moonlander.library.Moonlander;
import processing.core.PApplet;
import processing.core.PImage;
import processing.opengl.PShader;

public class demo
extends PApplet {
    PShader tunneli;
    int CANVAS_WIDTH = 1920;
    int CANVAS_HEIGHT = 1080;
    int SONG_SKIP_MILLISECONDS = 2000;
    float ASPECT_RATIO = (float)this.CANVAS_WIDTH / (float)this.CANVAS_HEIGHT;
    Minim minim;
    AudioPlayer song;
    Moonlander moonlander;
    PImage ninja;
    PImage taru;
    PImage miranda;
    PShader gre;
    PImage tex;

    public void setupAudio() {
        this.minim = new Minim((Object)this);
        this.song = this.minim.loadFile("They're Out There.mp3");
        this.song.play();
    }

    public void setup() {
        this.moonlander = Moonlander.initWithSoundtrack((PApplet)this, (String)"They're Out There.mp3", (int)127, (int)8);
        this.size(this.displayWidth, this.displayHeight, "processing.opengl.PGraphics3D");
        this.CANVAS_WIDTH = this.displayWidth;
        this.CANVAS_HEIGHT = this.displayHeight;
        this.ASPECT_RATIO = (float)this.CANVAS_WIDTH / (float)this.CANVAS_HEIGHT;
        this.noStroke();
        this.frameRate(30.0f);
        this.fill(255);
        this.smooth();
        this.rectMode(3);
        this.ninja = this.loadImage("sydanNinja.png");
        this.taru = this.loadImage("sydanTaru.png");
        this.miranda = this.loadImage("sydanMiranda.png");
        this.textureMode(1);
        this.tunneli = this.loadShader("tunneli.glsl");
        this.tunneli.set("iResolution", (float)this.width, (float)this.height);
        this.gre = this.loadShader("gre.glsl");
        this.tex = this.loadImage("data/graffathon.png");
        this.gre.set("iResolution", (float)this.width, (float)this.height);
        this.gre.set("iChannel0", this.tex);
        this.setupAudio();
        this.moonlander.start();
    }

    public void effect1(int n) {
        this.pushMatrix();
        this.background(0);
        this.stroke(60.0f, 0.0f, 100.0f);
        this.drawCircles(n, 0.0f, 0.001f, demo.cos((float)((float)n * 0.001f)) * 0.2f);
        this.popMatrix();
    }

    public void effect2(int n) {
        this.pushMatrix();
        this.background(0);
        this.scale(0.5f);
        this.noStroke();
        this.drawCircles(n, 0.4f * demo.sin((float)((float)n * 0.001f)), 0.001f, 0.0f);
        this.drawCircles(n, 0.8f * demo.sin((float)((float)n * 0.001f)), 0.0012f, 0.05f);
        this.drawCircles(n, 1.2f * demo.sin((float)((float)n * 0.001f)), 0.0013f, 0.07f);
        this.popMatrix();
    }

    public void effect3(int n) {
        this.pushMatrix();
        this.stroke(60.0f, 0.0f, 100.0f);
        this.scale(0.5f);
        this.drawCircles(n, 0.4f * demo.sin((float)((float)n * 0.001f)), 0.001f, 0.0f);
        this.popMatrix();
    }

    public void konnakursio(int n, int n2, int n3) {
        if (n2 <= 0) {
            return;
        }
        this.pushMatrix();
        this.scale(0.7f);
        float f = 10.0f * demo.sin((float)((float)n * 0.001f));
        this.rotateX(demo.radians((float)(200.0f + f)));
        this.rotateY(demo.radians((float)(50.0f + f)));
        this.fill(255.0f, 0.0f, (float)((n2 + 1) * 30) * (1.5f + demo.sin((float)((float)n * 0.001f))));
        this.noStroke();
        this.konna();
        int n4 = 0;
        while (n4 < n3) {
            this.rotateZ(1.0f);
            this.rotateX(1.0f);
            this.translate((float)(150 * n) * 1.0E-4f, 0.0f, 0.0f);
            this.konnakursio(n, n2 - 1, n3);
            ++n4;
        }
        this.popMatrix();
    }

    public void effectKonnaKursio(int n) {
        this.resetMatrix();
        this.background(0);
        this.imageMode(3);
        this.sphereDetail(10);
        this.pushMatrix();
        this.translate(0.0f, 150.0f, -800.0f);
        this.konnakursio(n, 8, 3);
        this.popMatrix();
    }

    public void konna() {
        this.scale(1.0f);
        this.sphere(100.0f);
    }

    public void konna2() {
        this.scale(1.0f);
        this.box(20.0f, 120.0f, 20.0f);
    }

    public void effectKonnaKursio2(int n) {
        this.resetMatrix();
        this.background(0);
        this.pushMatrix();
        this.translate(0.0f, (float)(-this.height) / 2.0f - 100.0f, -800.0f);
        this.konnakursio2(n, 30, 1);
        this.translate(-400.0f, -200.0f, -400.0f);
        this.konnakursio2(n, 30, 1);
        this.translate(800.0f, 0.0f, 0.0f);
        this.konnakursio2(n, 30, 1);
        this.popMatrix();
    }

    public void konnakursio2(int n, int n2, int n3) {
        if (n2 <= 0) {
            return;
        }
        if (n > 20000) {
            this.translate(100.0f, 300.0f, -100.0f);
            this.fill(100.0f, 255.0f, 150.0f + (float)((n2 + 1) * 10) * demo.sin((float)((float)n * 0.001f)));
        } else {
            this.fill(200.0f + (float)((n2 + 1) * 10) * demo.sin((float)((float)n * 0.001f)), 255.0f, 50 + (n2 + 1) * 10);
        }
        this.pushMatrix();
        this.scale(1.0f);
        this.noStroke();
        this.konna2();
        int n4 = 0;
        while (n4 < n3) {
            if (n > 20000) {
                this.rotateZ(1.0f);
            }
            this.rotateY(demo.radians((float)30.0f) * demo.sin((float)((float)n * 0.001f)));
            this.translate((float)(60 * n) * 1.0E-4f, 40.0f, 0.0f);
            this.konnakursio2(n, n2 - 1, n3);
            ++n4;
        }
        this.popMatrix();
    }

    public void texturedBox(float f, float f2, float f3, int n) {
        f *= 0.5f;
        f2 *= 0.5f;
        f3 *= 0.5f;
        this.noStroke();
        this.beginShape();
        if (n == 0) {
            this.texture(this.ninja);
        } else if (n == 1) {
            this.texture(this.taru);
        } else if (n == 2) {
            this.texture(this.miranda);
        }
        this.vertex(f, f2, f3, 1.0f, 1.0f);
        this.vertex(f, -f2, f3, 1.0f, 0.0f);
        this.vertex(-f, -f2, f3, 0.0f, 0.0f);
        this.vertex(-f, f2, f3, 0.0f, 1.0f);
        this.endShape();
    }

    public void sydamia() {
        this.scale(this.ASPECT_RATIO / ((float)this.CANVAS_WIDTH / 2.0f), -2.0f / (float)this.CANVAS_HEIGHT);
        this.scale(0.5f);
        int n = 0;
        while (n < 3) {
            this.pushMatrix();
            this.translate(-150.0f, -50.0f, 0.0f);
            this.translate(n * 150, 0.0f, 0.0f);
            this.rotateY((float)this.millis() * 0.005f);
            this.noStroke();
            this.texturedBox(50.0f, 100.0f, 10.0f, n);
            this.popMatrix();
            ++n;
        }
    }

    public void kuutioita() {
        this.shader(this.tunneli);
        this.scale(this.ASPECT_RATIO / ((float)this.CANVAS_WIDTH / 2.0f), -2.0f / (float)this.CANVAS_HEIGHT);
        this.scale(0.5f);
        int n = 0;
        while (n < 10) {
            int n2 = 0;
            while (n2 < 5) {
                this.pushMatrix();
                this.translate(-200.0f, 0.0f, 0.0f);
                this.translate(n2 * 100, 0.0f, -n * 400);
                if (n2 == 1 || n2 == 3) {
                    this.translate(0.0f, 100.0f, 0.0f);
                } else {
                    this.translate(0.0f, -100.0f, 0.0f);
                }
                this.tunneli.set("iGlobalTime", (float)this.millis() * 0.001f);
                this.rotateY((float)this.millis() * 0.005f);
                this.rotateZ((float)this.millis() * 1.0E-4f);
                this.noStroke();
                this.fill(200.0f, 30.0f, 100.0f);
                this.box(100.0f, 100.0f, 100.0f);
                this.popMatrix();
                ++n2;
            }
            ++n;
        }
    }

    public void greets(int n) {
        this.shader(this.gre);
        this.gre.set("iGlobalTime", (float)n * 0.001f);
        this.scale(this.ASPECT_RATIO / ((float)this.CANVAS_WIDTH / 2.0f), -2.0f / (float)this.CANVAS_HEIGHT);
        this.scale(0.5f);
        this.pushMatrix();
        this.fill(0.0f, 30.0f, 100.0f);
        this.translate(-200.0f, 200.0f, 0.0f);
        this.box(1920.0f, 1080.0f, 30.0f);
        this.popMatrix();
    }

    public void drawDemo(int n) {
        if (n < 10000) {
            this.resetShader();
            this.effect1(n);
        } else if (n < 19500) {
            this.resetShader();
            this.effect3(n - 10000);
        } else if (n < 30000) {
            this.resetShader();
            this.effect2(n - 19500);
        } else if (n < 60000) {
            this.resetShader();
            this.effectKonnaKursio(n - 30000);
        } else if (n < 100000) {
            this.resetShader();
            this.effectKonnaKursio2(n - 60000);
        } else if (n < 110000) {
            this.resetShader();
            this.sydamia();
        } else if (n < 120000) {
            this.resetShader();
            this.kuutioita();
        } else {
            this.resetShader();
            this.greets(n + 11000);
        }
    }

    public void drawCircles(float f, float f2, float f3, float f4) {
        this.pushMatrix();
        float f5 = 0.0f;
        while (f5 < 23.0f) {
            this.fill(f5 * 20.0f, 0.0f, f5 * 20.0f);
            this.ellipse(f2 * demo.sin((float)(f * f3 + f5 * 2.0f)), f2 * demo.cos((float)(f * f3 + f5 * 2.0f)), f4 + 1.0f / (f5 + 2.0f), f4 + 1.0f / (f5 + 2.0f));
            f5 += 1.0f;
        }
        this.popMatrix();
    }

    public void drawAxes() {
        this.stroke(255);
        this.strokeWeight(0.004f);
        this.fill(255);
    }

    public void draw() {
        this.moonlander.update();
        this.resetMatrix();
        this.translate(-50.0f, 0.0f, -200.0f);
        this.scale((float)this.CANVAS_WIDTH / 2.0f / this.ASPECT_RATIO, (float)(-this.CANVAS_HEIGHT) / 2.0f);
        this.clear();
        this.drawAxes();
        this.drawDemo(this.millis());
    }

    public void keyPressed() {
        if (this.key == '\uffff') {
            if (this.keyCode == 37) {
                this.song.skip(-this.SONG_SKIP_MILLISECONDS);
            } else if (this.keyCode == 39) {
                this.song.skip(this.SONG_SKIP_MILLISECONDS);
            }
        } else if (this.key == ' ') {
            if (this.song.isPlaying()) {
                this.song.pause();
            } else {
                this.song.play();
            }
        } else if (this.key == '\n') {
            demo.print((String)(String.valueOf(this.song.position()) + ", "));
        }
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"--full-screen", "--bgcolor=#666666", "--hide-stop", "demo"};
        if (stringArray != null) {
            PApplet.main((String[])demo.concat((String[])stringArray2, (String[])stringArray));
        } else {
            PApplet.main((String[])stringArray2);
        }
    }
}

