/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.os;

import com.jogamp.common.os.Platform;
import jogamp.common.os.PlatformPropsImpl;

public class MachineDescription {
    private static final int[] size_armeabi = new int[]{4, 4, 4, 8, 8, 4, 4096};
    private static final int[] size_x86_32_unix = new int[]{4, 4, 4, 8, 12, 4, 4096};
    private static final int[] size_x86_32_macos = new int[]{4, 4, 4, 8, 16, 4, 4096};
    private static final int[] size_x86_32_windows = new int[]{4, 4, 4, 8, 12, 4, 4096};
    private static final int[] size_x86_64_unix = new int[]{4, 8, 4, 8, 16, 8, 4096};
    private static final int[] size_x86_64_windows = new int[]{4, 4, 4, 8, 16, 8, 4096};
    private static final int[] size_sparc_32_sunos = new int[]{4, 4, 4, 8, 16, 4, 8192};
    private static final int[] align_armeabi = new int[]{1, 2, 4, 8, 4, 4, 4, 8, 8, 4};
    private static final int[] align_x86_32_unix = new int[]{1, 2, 4, 4, 4, 4, 4, 4, 4, 4};
    private static final int[] align_x86_32_macos = new int[]{1, 2, 4, 4, 4, 4, 4, 4, 16, 4};
    private static final int[] align_x86_32_windows = new int[]{1, 2, 4, 8, 4, 4, 4, 8, 4, 4};
    private static final int[] align_x86_64_unix = new int[]{1, 2, 4, 8, 4, 8, 4, 8, 16, 8};
    private static final int[] align_x86_64_windows = new int[]{1, 2, 4, 8, 4, 4, 4, 8, 16, 8};
    private static final int[] align_sparc_32_sunos = new int[]{1, 2, 4, 8, 4, 4, 4, 8, 8, 4};
    private final boolean runtimeValidated;
    private final boolean littleEndian;
    private final int int8SizeInBytes = 1;
    private final int int16SizeInBytes = 2;
    private final int int32SizeInBytes = 4;
    private final int int64SizeInBytes = 8;
    private final int intSizeInBytes;
    private final int longSizeInBytes;
    private final int floatSizeInBytes;
    private final int doubleSizeInBytes;
    private final int ldoubleSizeInBytes;
    private final int pointerSizeInBytes;
    private final int pageSizeInBytes;
    private final boolean is32Bit;
    private final int int8AlignmentInBytes;
    private final int int16AlignmentInBytes;
    private final int int32AlignmentInBytes;
    private final int int64AlignmentInBytes;
    private final int intAlignmentInBytes;
    private final int longAlignmentInBytes;
    private final int floatAlignmentInBytes;
    private final int doubleAlignmentInBytes;
    private final int ldoubleAlignmentInBytes;
    private final int pointerAlignmentInBytes;

    public MachineDescription(boolean bl, boolean bl2, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16, int n17) {
        this.runtimeValidated = bl;
        this.littleEndian = bl2;
        this.intSizeInBytes = n;
        this.longSizeInBytes = n2;
        this.floatSizeInBytes = n3;
        this.doubleSizeInBytes = n4;
        this.ldoubleSizeInBytes = n5;
        this.pointerSizeInBytes = n6;
        this.pageSizeInBytes = n7;
        this.is32Bit = 4 == n6;
        this.int8AlignmentInBytes = n8;
        this.int16AlignmentInBytes = n9;
        this.int32AlignmentInBytes = n10;
        this.int64AlignmentInBytes = n11;
        this.intAlignmentInBytes = n12;
        this.longAlignmentInBytes = n13;
        this.floatAlignmentInBytes = n14;
        this.doubleAlignmentInBytes = n15;
        this.ldoubleAlignmentInBytes = n16;
        this.pointerAlignmentInBytes = n17;
    }

    public final boolean isRuntimeValidated() {
        return this.runtimeValidated;
    }

    public final boolean isLittleEndian() {
        return this.littleEndian;
    }

    public final boolean is32Bit() {
        return this.is32Bit;
    }

    public final boolean is64Bit() {
        return !this.is32Bit;
    }

    public final int intSizeInBytes() {
        return this.intSizeInBytes;
    }

    public final int longSizeInBytes() {
        return this.longSizeInBytes;
    }

    public final int int8SizeInBytes() {
        return 1;
    }

    public final int int16SizeInBytes() {
        return 2;
    }

    public final int int32SizeInBytes() {
        return 4;
    }

    public final int int64SizeInBytes() {
        return 8;
    }

    public final int floatSizeInBytes() {
        return this.floatSizeInBytes;
    }

    public final int doubleSizeInBytes() {
        return this.doubleSizeInBytes;
    }

    public final int ldoubleSizeInBytes() {
        return this.ldoubleSizeInBytes;
    }

    public final int pointerSizeInBytes() {
        return this.pointerSizeInBytes;
    }

    public final int pageSizeInBytes() {
        return this.pageSizeInBytes;
    }

    public final int intAlignmentInBytes() {
        return this.intAlignmentInBytes;
    }

    public final int longAlignmentInBytes() {
        return this.longAlignmentInBytes;
    }

    public final int int8AlignmentInBytes() {
        return this.int8AlignmentInBytes;
    }

    public final int int16AlignmentInBytes() {
        return this.int16AlignmentInBytes;
    }

    public final int int32AlignmentInBytes() {
        return this.int32AlignmentInBytes;
    }

    public final int int64AlignmentInBytes() {
        return this.int64AlignmentInBytes;
    }

    public final int floatAlignmentInBytes() {
        return this.floatAlignmentInBytes;
    }

    public final int doubleAlignmentInBytes() {
        return this.doubleAlignmentInBytes;
    }

    public final int ldoubleAlignmentInBytes() {
        return this.ldoubleAlignmentInBytes;
    }

    public final int pointerAlignmentInBytes() {
        return this.pointerAlignmentInBytes;
    }

    public int pageCount(int n) {
        return (n + (this.pageSizeInBytes - 1)) / this.pageSizeInBytes;
    }

    public int pageAlignedSize(int n) {
        return this.pageCount(n) * this.pageSizeInBytes;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MachineDescription)) {
            return false;
        }
        MachineDescription machineDescription = (MachineDescription)object;
        return this.pageSizeInBytes == machineDescription.pageSizeInBytes && this.compatible(machineDescription);
    }

    public final boolean compatible(MachineDescription machineDescription) {
        return this.littleEndian == machineDescription.littleEndian && this.intSizeInBytes == machineDescription.intSizeInBytes && this.longSizeInBytes == machineDescription.longSizeInBytes && this.floatSizeInBytes == machineDescription.floatSizeInBytes && this.doubleSizeInBytes == machineDescription.doubleSizeInBytes && this.ldoubleSizeInBytes == machineDescription.ldoubleSizeInBytes && this.pointerSizeInBytes == machineDescription.pointerSizeInBytes && this.is32Bit == machineDescription.is32Bit && this.int8AlignmentInBytes == machineDescription.int8AlignmentInBytes && this.int16AlignmentInBytes == machineDescription.int16AlignmentInBytes && this.int32AlignmentInBytes == machineDescription.int32AlignmentInBytes && this.int64AlignmentInBytes == machineDescription.int64AlignmentInBytes && this.intAlignmentInBytes == machineDescription.intAlignmentInBytes && this.longAlignmentInBytes == machineDescription.longAlignmentInBytes && this.floatAlignmentInBytes == machineDescription.floatAlignmentInBytes && this.doubleAlignmentInBytes == machineDescription.doubleAlignmentInBytes && this.ldoubleAlignmentInBytes == machineDescription.ldoubleAlignmentInBytes && this.pointerAlignmentInBytes == machineDescription.pointerAlignmentInBytes;
    }

    public StringBuilder toString(StringBuilder stringBuilder) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        stringBuilder.append("MachineDescription: runtimeValidated ").append(this.isRuntimeValidated()).append(", littleEndian ").append(this.isLittleEndian()).append(", 32Bit ").append(this.is32Bit()).append(", primitive size / alignment:").append(PlatformPropsImpl.NEWLINE);
        stringBuilder.append("  int8    ").append(1).append(" / ").append(this.int8AlignmentInBytes);
        stringBuilder.append(", int16   ").append(2).append(" / ").append(this.int16AlignmentInBytes).append(Platform.getNewline());
        stringBuilder.append("  int     ").append(this.intSizeInBytes).append(" / ").append(this.intAlignmentInBytes);
        stringBuilder.append(", long    ").append(this.longSizeInBytes).append(" / ").append(this.longAlignmentInBytes).append(Platform.getNewline());
        stringBuilder.append("  int32   ").append(4).append(" / ").append(this.int32AlignmentInBytes);
        stringBuilder.append(", int64   ").append(8).append(" / ").append(this.int64AlignmentInBytes).append(Platform.getNewline());
        stringBuilder.append("  float   ").append(this.floatSizeInBytes).append(" / ").append(this.floatAlignmentInBytes);
        stringBuilder.append(", double  ").append(this.doubleSizeInBytes).append(" / ").append(this.doubleAlignmentInBytes);
        stringBuilder.append(", ldouble ").append(this.ldoubleSizeInBytes).append(" / ").append(this.ldoubleAlignmentInBytes).append(Platform.getNewline());
        stringBuilder.append("  pointer ").append(this.pointerSizeInBytes).append(" / ").append(this.pointerAlignmentInBytes);
        stringBuilder.append(", page    ").append(this.pageSizeInBytes);
        return stringBuilder;
    }

    public String toString() {
        return this.toString(null).toString();
    }

    static /* synthetic */ int[] access$000() {
        return size_armeabi;
    }

    static /* synthetic */ int[] access$100() {
        return align_armeabi;
    }

    static /* synthetic */ int[] access$200() {
        return size_x86_32_unix;
    }

    static /* synthetic */ int[] access$300() {
        return align_x86_32_unix;
    }

    static /* synthetic */ int[] access$400() {
        return size_x86_64_unix;
    }

    static /* synthetic */ int[] access$500() {
        return align_x86_64_unix;
    }

    static /* synthetic */ int[] access$600() {
        return size_x86_32_macos;
    }

    static /* synthetic */ int[] access$700() {
        return align_x86_32_macos;
    }

    static /* synthetic */ int[] access$800() {
        return size_x86_32_windows;
    }

    static /* synthetic */ int[] access$900() {
        return align_x86_32_windows;
    }

    static /* synthetic */ int[] access$1000() {
        return size_x86_64_windows;
    }

    static /* synthetic */ int[] access$1100() {
        return align_x86_64_windows;
    }

    static /* synthetic */ int[] access$1200() {
        return size_sparc_32_sunos;
    }

    static /* synthetic */ int[] access$1300() {
        return align_sparc_32_sunos;
    }

    public static enum StaticConfig {
        ARMle_EABI(ID.ARMle_EABI, true, MachineDescription.access$000(), MachineDescription.access$100()),
        X86_32_UNIX(ID.X86_32_UNIX, true, MachineDescription.access$200(), MachineDescription.access$300()),
        X86_64_UNIX(ID.X86_64_UNIX, true, MachineDescription.access$400(), MachineDescription.access$500()),
        X86_32_MACOS(ID.X86_32_MACOS, true, MachineDescription.access$600(), MachineDescription.access$700()),
        X86_32_WINDOWS(ID.X86_32_WINDOWS, true, MachineDescription.access$800(), MachineDescription.access$900()),
        X86_64_WINDOWS(ID.X86_64_WINDOWS, true, MachineDescription.access$1000(), MachineDescription.access$1100()),
        SPARC_32_SUNOS(ID.SPARC_32_SUNOS, false, MachineDescription.access$1200(), MachineDescription.access$1300());

        public final ID id;
        public final MachineDescription md;

        private StaticConfig(ID iD, boolean bl, int[] nArray, int[] nArray2) {
            this.id = iD;
            int n2 = 0;
            int n3 = 0;
            this.md = new MachineDescription(false, bl, nArray[n2++], nArray[n2++], nArray[n2++], nArray[n2++], nArray[n2++], nArray[n2++], nArray[n2++], nArray2[n3++], nArray2[n3++], nArray2[n3++], nArray2[n3++], nArray2[n3++], nArray2[n3++], nArray2[n3++], nArray2[n3++], nArray2[n3++], nArray2[n3++]);
        }

        public StringBuilder toString(StringBuilder stringBuilder) {
            if (null == stringBuilder) {
                stringBuilder = new StringBuilder();
            }
            stringBuilder.append("MachineDescriptionStatic: ").append(this.name()).append("(").append(this.ordinal()).append("): ");
            this.md.toString(stringBuilder);
            return stringBuilder;
        }

        public String toString() {
            return this.toString(null).toString();
        }
    }

    public static enum ID {
        ARMle_EABI(Platform.CPUType.ARM),
        X86_32_UNIX(Platform.CPUType.X86_32),
        X86_64_UNIX(Platform.CPUType.X86_64),
        X86_32_MACOS(Platform.CPUType.X86_32),
        X86_32_WINDOWS(Platform.CPUType.X86_32),
        X86_64_WINDOWS(Platform.CPUType.X86_64),
        SPARC_32_SUNOS(Platform.CPUType.SPARC_32);

        public final Platform.CPUType cpu;

        private ID(Platform.CPUType cPUType) {
            this.cpu = cPUType;
        }
    }
}

