/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.ugens;

import ddf.minim.UGen;

public class EnvelopeFollower
extends UGen {
    public UGen.UGenInput audio;
    private float m_attack;
    private float m_release;
    private float m_ga;
    private float m_gr;
    private float[] m_buffer;
    private int m_bufferCount;
    private float m_envelope;
    private float m_prevEnvelope;

    public EnvelopeFollower(float f, float f2, int n) {
        this.m_attack = f;
        this.m_release = f2;
        this.m_buffer = new float[n];
        this.m_bufferCount = 0;
        this.m_envelope = 0.0f;
        this.m_prevEnvelope = 0.0f;
        this.audio = new UGen.UGenInput(UGen.InputType.AUDIO);
    }

    @Override
    protected void sampleRateChanged() {
        this.m_ga = (float)Math.exp(-1.0f / (this.sampleRate() * this.m_attack));
        this.m_gr = (float)Math.exp(-1.0f / (this.sampleRate() * this.m_release));
    }

    @Override
    protected void uGenerate(float[] fArray) {
        int n;
        float f = 0.0f;
        float[] fArray2 = this.audio.getLastValues();
        for (n = 0; n < fArray2.length; ++n) {
            f += fArray2[n] / (float)fArray2.length;
        }
        this.m_buffer[this.m_bufferCount++] = f;
        if (this.m_bufferCount == this.m_buffer.length) {
            this.m_prevEnvelope = this.m_envelope;
            this.m_envelope = 0.0f;
            for (n = 0; n < this.m_buffer.length; ++n) {
                float f2 = Math.abs(this.m_buffer[n]);
                if (this.m_envelope < f2) {
                    this.m_envelope *= this.m_ga;
                    this.m_envelope += (1.0f - this.m_ga) * f2;
                    continue;
                }
                this.m_envelope *= this.m_gr;
                this.m_envelope += (1.0f - this.m_gr) * f2;
            }
            this.m_bufferCount = 0;
        }
        float f3 = this.m_prevEnvelope + (this.m_envelope - this.m_prevEnvelope) * ((float)this.m_bufferCount / (float)this.m_buffer.length);
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = f3;
        }
    }
}

