/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim;

import ddf.minim.AudioBuffer;
import ddf.minim.Minim;

final class MAudioBuffer
implements AudioBuffer {
    private float[] samples;

    MAudioBuffer(int n) {
        this.samples = new float[n];
    }

    @Override
    public synchronized int size() {
        return this.samples.length;
    }

    @Override
    public synchronized float get(int n) {
        return this.samples[n];
    }

    public synchronized float get(float f) {
        int n = (int)f;
        int n2 = n + 1;
        if (n2 == this.samples.length) {
            return this.samples[n];
        }
        float f2 = f - (float)n;
        return this.samples[n] + f2 * (this.samples[n2] - this.samples[n]);
    }

    public synchronized void set(float[] fArray) {
        if (fArray.length != this.samples.length) {
            Minim.error("MAudioBuffer.set: passed array (" + fArray.length + ") " + "must be the same length (" + this.samples.length + ") as this MAudioBuffer.");
        } else {
            this.samples = fArray;
        }
    }

    public synchronized void mix(float[] fArray, float[] fArray2) {
        if (fArray.length != fArray2.length || fArray.length != this.samples.length || fArray2.length != this.samples.length) {
            Minim.error("MAudioBuffer.mix: The two passed buffers must be the same size as this MAudioBuffer.");
        } else {
            for (int i = 0; i < this.samples.length; ++i) {
                this.samples[i] = (fArray[i] + fArray2[i]) / 2.0f;
            }
        }
    }

    public synchronized void clear() {
        this.samples = new float[this.samples.length];
    }

    @Override
    public synchronized float level() {
        float f = 0.0f;
        for (int i = 0; i < this.samples.length; ++i) {
            f += this.samples[i] * this.samples[i];
        }
        f /= (float)this.samples.length;
        f = (float)Math.sqrt(f);
        return f;
    }

    @Override
    public synchronized float[] toArray() {
        float[] fArray = new float[this.samples.length];
        System.arraycopy(this.samples, 0, fArray, 0, this.samples.length);
        return fArray;
    }
}

