/*
 * Decompiled with CFR 0.152.
 */
package moonlander.library;

class TrackKey
implements Comparable<TrackKey> {
    private int row;
    private float value;
    private KeyType keyType;

    public TrackKey(int n, float f, KeyType keyType) {
        this.row = n;
        this.value = f;
        this.keyType = keyType;
    }

    public TrackKey(int n, float f, int n2) {
        this(n, f, KeyType.values()[n2]);
    }

    public int getRow() {
        return this.row;
    }

    public void setRow(int n) {
        this.row = n;
    }

    public float getValue() {
        return this.value;
    }

    public void setValue(float f) {
        this.value = f;
    }

    public KeyType getKeyType() {
        return this.keyType;
    }

    public void setKeyType(KeyType keyType) {
        this.keyType = keyType;
    }

    @Override
    public int compareTo(TrackKey trackKey) {
        return this.row > trackKey.row ? 1 : (this.row < trackKey.row ? -1 : 0);
    }

    public String toString() {
        return String.format("TrackKey(row=%d value=%f type=%s)", new Object[]{this.row, Float.valueOf(this.value), this.keyType});
    }

    public static double interpolate(TrackKey trackKey, TrackKey trackKey2, double d) {
        double d2 = (d - (double)trackKey.row) / (double)(trackKey2.row - trackKey.row);
        switch (trackKey.keyType) {
            case STEP: {
                return trackKey.value;
            }
            case SMOOTH: {
                d2 = d2 * d2 * (3.0 - 2.0 * d2);
                break;
            }
            case RAMP: {
                d2 = Math.pow(d2, 2.0);
            }
        }
        return (double)trackKey.value + (double)(trackKey2.value - trackKey.value) * d2;
    }

    public static enum KeyType {
        STEP,
        LINEAR,
        SMOOTH,
        RAMP;

    }
}

