/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.signals;

import ddf.minim.AudioSignal;

public class WhiteNoise
implements AudioSignal {
    protected float amp;
    protected float pan;
    protected float leftScale;
    protected float rightScale;

    public WhiteNoise() {
        this.amp = 1.0f;
        this.pan = 0.0f;
        this.rightScale = 1.0f;
        this.leftScale = 1.0f;
    }

    public WhiteNoise(float f) {
        this.setAmp(f);
        this.pan = 0.0f;
        this.rightScale = 1.0f;
        this.leftScale = 1.0f;
    }

    public void setAmp(float f) {
        this.amp = this.constrain(f, 0.0f, 1.0f);
    }

    public void setPan(float f) {
        this.pan = this.constrain(f, -1.0f, 1.0f);
        this.calcLRScale();
    }

    @Override
    public void generate(float[] fArray) {
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = this.amp * (2.0f * (float)Math.random() - 1.0f);
        }
    }

    @Override
    public void generate(float[] fArray, float[] fArray2) {
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = this.leftScale * this.amp * (2.0f * (float)Math.random() - 1.0f);
            fArray2[i] = this.rightScale * this.amp * (2.0f * (float)Math.random() - 1.0f);
        }
    }

    private void calcLRScale() {
        if (this.pan <= 0.0f) {
            this.rightScale = this.pan + 1.0f;
            this.leftScale = 1.0f;
        }
        if (this.pan >= 0.0f) {
            this.leftScale = 1.0f - this.pan;
            this.rightScale = 1.0f;
        }
        if (this.pan == 0.0f) {
            this.rightScale = 1.0f;
            this.leftScale = 1.0f;
        }
    }

    float constrain(float f, float f2, float f3) {
        return f < f2 ? f2 : (f > f3 ? f3 : f);
    }
}

