/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.analysis;

import ddf.minim.Minim;
import ddf.minim.analysis.FourierTransform;

public class DFT
extends FourierTransform {
    private float[] sinlookup;
    private float[] coslookup;

    public DFT(int n, float f) {
        super(n, f);
        if (n % 2 != 0) {
            throw new IllegalArgumentException("DFT: timeSize must be even.");
        }
        this.buildTrigTables();
    }

    @Override
    protected void allocateArrays() {
        this.spectrum = new float[this.timeSize / 2 + 1];
        this.real = new float[this.timeSize / 2 + 1];
        this.imag = new float[this.timeSize / 2 + 1];
    }

    @Override
    public void scaleBand(int n, float f) {
    }

    @Override
    public void setBand(int n, float f) {
    }

    @Override
    public void forward(float[] fArray) {
        if (fArray.length != this.timeSize) {
            Minim.error("DFT.forward: The length of the passed sample buffer must be equal to DFT.timeSize().");
            return;
        }
        this.doWindow(fArray);
        int n = fArray.length;
        for (int i = 0; i <= n / 2; ++i) {
            this.real[i] = 0.0f;
            this.imag[i] = 0.0f;
            for (int j = 0; j < n; ++j) {
                int n2 = i;
                this.real[n2] = this.real[n2] + fArray[j] * this.cos(j * i);
                int n3 = i;
                this.imag[n3] = this.imag[n3] + fArray[j] * -this.sin(j * i);
            }
        }
        this.fillSpectrum();
    }

    @Override
    public void inverse(float[] fArray) {
        int n;
        int n2 = fArray.length;
        this.real[0] = this.real[0] / (float)n2;
        this.imag[0] = -this.imag[0] / (float)(n2 / 2);
        int n3 = n2 / 2;
        this.real[n3] = this.real[n3] / (float)n2;
        this.imag[n2 / 2] = -this.imag[0] / (float)(n2 / 2);
        for (n = 0; n < n2 / 2; ++n) {
            int n4 = n;
            this.real[n4] = this.real[n4] / (float)(n2 / 2);
            this.imag[n] = -this.imag[n] / (float)(n2 / 2);
        }
        for (n = 0; n < n2; ++n) {
            fArray[n] = 0.0f;
            for (int i = 0; i < n2 / 2; ++i) {
                int n5 = n;
                fArray[n5] = fArray[n5] + (this.real[i] * this.cos(n * i) + this.imag[i] * this.sin(n * i));
            }
        }
    }

    private void buildTrigTables() {
        int n = this.spectrum.length * this.timeSize;
        this.sinlookup = new float[n];
        this.coslookup = new float[n];
        for (int i = 0; i < n; ++i) {
            this.sinlookup[i] = (float)Math.sin((float)i * ((float)Math.PI * 2) / (float)this.timeSize);
            this.coslookup[i] = (float)Math.cos((float)i * ((float)Math.PI * 2) / (float)this.timeSize);
        }
    }

    private float sin(int n) {
        return this.sinlookup[n];
    }

    private float cos(int n) {
        return this.coslookup[n];
    }
}

