/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.javasound;

import java.util.List;
import java.util.Random;
import javax.sound.sampled.AudioFormat;

public class FloatSampleTools {
    public static final float DEFAULT_DITHER_BITS = 0.7f;
    private static Random random = null;
    static final int F_8 = 1;
    static final int F_16 = 2;
    static final int F_24_3 = 3;
    static final int F_24_4 = 4;
    static final int F_32 = 5;
    static final int F_SAMPLE_WIDTH_MASK = 7;
    static final int F_SIGNED = 8;
    static final int F_BIGENDIAN = 16;
    static final int CT_8S = 9;
    static final int CT_8U = 1;
    static final int CT_16SB = 26;
    static final int CT_16SL = 10;
    static final int CT_24_3SB = 27;
    static final int CT_24_3SL = 11;
    static final int CT_24_4SB = 28;
    static final int CT_24_4SL = 12;
    static final int CT_32SB = 29;
    static final int CT_32SL = 13;
    private static final float twoPower7 = 128.0f;
    private static final float twoPower15 = 32768.0f;
    private static final float twoPower23 = 8388608.0f;
    private static final float twoPower31 = 2.1474836E9f;
    private static final float invTwoPower7 = 0.0078125f;
    private static final float invTwoPower15 = 3.0517578E-5f;
    private static final float invTwoPower23 = 1.1920929E-7f;
    private static final float invTwoPower31 = 4.656613E-10f;

    private FloatSampleTools() {
    }

    static void checkSupportedSampleSize(int n, int n2, int n3) {
        if (n == 24 && n3 == 4 * n2) {
            return;
        }
        if (n * n2 != n3 * 8) {
            throw new IllegalArgumentException("unsupported sample size: " + n + " bits stored in " + n3 / n2 + " bytes.");
        }
    }

    static int getFormatType(AudioFormat audioFormat) {
        boolean bl = audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED);
        if (!bl && !audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED)) {
            throw new IllegalArgumentException("unsupported encoding: only PCM encoding supported.");
        }
        if (!bl && audioFormat.getSampleSizeInBits() != 8) {
            throw new IllegalArgumentException("unsupported encoding: only 8-bit can be unsigned");
        }
        FloatSampleTools.checkSupportedSampleSize(audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), audioFormat.getFrameSize());
        int n = FloatSampleTools.getFormatType(audioFormat.getSampleSizeInBits(), audioFormat.getFrameSize() / audioFormat.getChannels(), bl, audioFormat.isBigEndian());
        return n;
    }

    static int getFormatType(int n, int n2, boolean bl, boolean bl2) {
        int n3 = 0;
        if (n == 24 || n2 == n / 8) {
            if (n == 8) {
                n3 = 1;
            } else if (n == 16) {
                n3 = 2;
            } else if (n == 24) {
                if (n2 == 3) {
                    n3 = 3;
                } else if (n2 == 4) {
                    n3 = 4;
                }
            } else if (n == 32) {
                n3 = 5;
            }
        }
        if (n3 == 0) {
            throw new IllegalArgumentException("ConversionTool: unsupported sample size of " + n + " bits per sample in " + n2 + " bytes.");
        }
        if (!bl && n2 > 1) {
            throw new IllegalArgumentException("ConversionTool: unsigned samples larger than 8 bit are not supported");
        }
        if (bl) {
            n3 |= 8;
        }
        if (bl2 && n != 8) {
            n3 |= 0x10;
        }
        return n3;
    }

    static int getSampleSize(int n) {
        switch (n & 7) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 4;
            }
        }
        return 0;
    }

    static String formatType2Str(int n) {
        String string = "" + n + ": ";
        switch (n & 7) {
            case 1: {
                string = string + "8bit";
                break;
            }
            case 2: {
                string = string + "16bit";
                break;
            }
            case 3: {
                string = string + "24_3bit";
                break;
            }
            case 4: {
                string = string + "24_4bit";
                break;
            }
            case 5: {
                string = string + "32bit";
            }
        }
        string = string + ((n & 8) == 8 ? " signed" : " unsigned");
        if ((n & 7) != 1) {
            string = string + ((n & 0x10) == 16 ? " big endian" : " little endian");
        }
        return string;
    }

    public static void byte2float(byte[] byArray, int n, List<float[]> list, int n2, int n3, AudioFormat audioFormat) {
        FloatSampleTools.byte2float(byArray, n, list, n2, n3, audioFormat, true);
    }

    public static void byte2float(byte[] byArray, int n, Object[] objectArray, int n2, int n3, AudioFormat audioFormat) {
        FloatSampleTools.byte2float(byArray, n, objectArray, n2, n3, audioFormat, true);
    }

    public static void byte2float(byte[] byArray, int n, Object[] objectArray, int n2, int n3, AudioFormat audioFormat, boolean bl) {
        int n4 = audioFormat.getChannels();
        if (!bl && n4 > objectArray.length) {
            n4 = objectArray.length;
        }
        if (objectArray.length < n4) {
            throw new ArrayIndexOutOfBoundsException("too few channel output array");
        }
        for (int i = 0; i < n4; ++i) {
            float[] fArray = (float[])objectArray[i];
            if (fArray.length < n3 + n2) {
                fArray = new float[n3 + n2];
                objectArray[i] = fArray;
            }
            FloatSampleTools.byte2floatGeneric(byArray, n, audioFormat.getFrameSize(), fArray, n2, n3, audioFormat);
            n += audioFormat.getFrameSize() / audioFormat.getChannels();
        }
    }

    public static void byte2float(byte[] byArray, int n, List<float[]> list, int n2, int n3, AudioFormat audioFormat, boolean bl) {
        int n4 = audioFormat.getChannels();
        if (!bl && n4 > list.size()) {
            n4 = list.size();
        }
        for (int i = 0; i < n4; ++i) {
            float[] fArray;
            if (list.size() < i) {
                fArray = new float[n3 + n2];
                list.add(fArray);
            } else {
                fArray = list.get(i);
                if (fArray.length < n3 + n2) {
                    fArray = new float[n3 + n2];
                    list.set(i, fArray);
                }
            }
            FloatSampleTools.byte2floatGeneric(byArray, n, audioFormat.getFrameSize(), fArray, n2, n3, audioFormat);
            n += audioFormat.getFrameSize() / audioFormat.getChannels();
        }
    }

    public static void byte2float(int n, byte[] byArray, int n2, float[] fArray, int n3, int n4, AudioFormat audioFormat) {
        if (n >= audioFormat.getChannels()) {
            throw new IllegalArgumentException("channel out of bounds");
        }
        if (fArray.length < n4 + n3) {
            throw new IllegalArgumentException("data is too small");
        }
        FloatSampleTools.byte2floatGeneric(byArray, n2 += audioFormat.getFrameSize() / audioFormat.getChannels() * n, audioFormat.getFrameSize(), fArray, n3, n4, audioFormat);
    }

    public static void byte2floatInterleaved(byte[] byArray, int n, float[] fArray, int n2, int n3, AudioFormat audioFormat) {
        FloatSampleTools.byte2floatGeneric(byArray, n, audioFormat.getFrameSize() / audioFormat.getChannels(), fArray, n2, n3 * audioFormat.getChannels(), audioFormat);
    }

    static void byte2floatGeneric(byte[] byArray, int n, int n2, float[] fArray, int n3, int n4, AudioFormat audioFormat) {
        int n5 = FloatSampleTools.getFormatType(audioFormat);
        FloatSampleTools.byte2floatGeneric(byArray, n, n2, fArray, n3, n4, n5);
    }

    static void byte2floatGeneric(byte[] byArray, int n, int n2, float[] fArray, int n3, int n4, int n5) {
        int n6 = n3 + n4;
        int n7 = n;
        int n8 = n3;
        while (n8 < n6) {
            switch (n5) {
                case 9: {
                    fArray[n8] = (float)byArray[n7] * 0.0078125f;
                    break;
                }
                case 1: {
                    fArray[n8] = (float)((byArray[n7] & 0xFF) - 128) * 0.0078125f;
                    break;
                }
                case 26: {
                    fArray[n8] = (float)(byArray[n7] << 8 | byArray[n7 + 1] & 0xFF) * 3.0517578E-5f;
                    break;
                }
                case 10: {
                    fArray[n8] = (float)(byArray[n7 + 1] << 8 | byArray[n7] & 0xFF) * 3.0517578E-5f;
                    break;
                }
                case 27: {
                    fArray[n8] = (float)(byArray[n7] << 16 | (byArray[n7 + 1] & 0xFF) << 8 | byArray[n7 + 2] & 0xFF) * 1.1920929E-7f;
                    break;
                }
                case 11: {
                    fArray[n8] = (float)(byArray[n7 + 2] << 16 | (byArray[n7 + 1] & 0xFF) << 8 | byArray[n7] & 0xFF) * 1.1920929E-7f;
                    break;
                }
                case 28: {
                    fArray[n8] = (float)(byArray[n7 + 1] << 16 | (byArray[n7 + 2] & 0xFF) << 8 | byArray[n7 + 3] & 0xFF) * 1.1920929E-7f;
                    break;
                }
                case 12: {
                    fArray[n8] = (float)(byArray[n7 + 3] << 16 | (byArray[n7 + 2] & 0xFF) << 8 | byArray[n7 + 1] & 0xFF) * 1.1920929E-7f;
                    break;
                }
                case 29: {
                    fArray[n8] = (float)(byArray[n7] << 24 | (byArray[n7 + 1] & 0xFF) << 16 | (byArray[n7 + 2] & 0xFF) << 8 | byArray[n7 + 3] & 0xFF) * 4.656613E-10f;
                    break;
                }
                case 13: {
                    fArray[n8] = (float)(byArray[n7 + 3] << 24 | (byArray[n7 + 2] & 0xFF) << 16 | (byArray[n7 + 1] & 0xFF) << 8 | byArray[n7] & 0xFF) * 4.656613E-10f;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unsupported format=" + FloatSampleTools.formatType2Str(n5));
                }
            }
            ++n8;
            n7 += n2;
        }
    }

    private static byte quantize8(float f, float f2) {
        if (f2 != 0.0f) {
            f += random.nextFloat() * f2;
        }
        if (f >= 127.0f) {
            return 127;
        }
        if (f <= -128.0f) {
            return -128;
        }
        return (byte)(f < 0.0f ? f - 0.5f : f + 0.5f);
    }

    private static int quantize16(float f, float f2) {
        if (f2 != 0.0f) {
            f += random.nextFloat() * f2;
        }
        if (f >= 32767.0f) {
            return Short.MAX_VALUE;
        }
        if (f <= -32768.0f) {
            return Short.MIN_VALUE;
        }
        return (int)(f < 0.0f ? f - 0.5f : f + 0.5f);
    }

    private static int quantize24(float f, float f2) {
        if (f2 != 0.0f) {
            f += random.nextFloat() * f2;
        }
        if (f >= 8388607.0f) {
            return 0x7FFFFF;
        }
        if (f <= -8388608.0f) {
            return -8388608;
        }
        return (int)(f < 0.0f ? f - 0.5f : f + 0.5f);
    }

    private static int quantize32(float f, float f2) {
        if (f2 != 0.0f) {
            f += random.nextFloat() * f2;
        }
        if (f >= 2.1474836E9f) {
            return Integer.MAX_VALUE;
        }
        if (f <= -2.1474836E9f) {
            return Integer.MIN_VALUE;
        }
        return (int)(f < 0.0f ? f - 0.5f : f + 0.5f);
    }

    public static void float2byte(List<float[]> list, int n, byte[] byArray, int n2, int n3, AudioFormat audioFormat, float f) {
        for (int i = 0; i < audioFormat.getChannels(); ++i) {
            float[] fArray = list.get(i);
            FloatSampleTools.float2byteGeneric(fArray, n, byArray, n2, audioFormat.getFrameSize(), n3, audioFormat, f);
            n2 += audioFormat.getFrameSize() / audioFormat.getChannels();
        }
    }

    public static void float2byte(Object[] objectArray, int n, byte[] byArray, int n2, int n3, AudioFormat audioFormat, float f) {
        int n4 = audioFormat.getChannels();
        for (int i = 0; i < n4; ++i) {
            float[] fArray = (float[])objectArray[i];
            FloatSampleTools.float2byteGeneric(fArray, n, byArray, n2, audioFormat.getFrameSize(), n3, audioFormat, f);
            n2 += audioFormat.getFrameSize() / audioFormat.getChannels();
        }
    }

    static void float2byte(Object[] objectArray, int n, byte[] byArray, int n2, int n3, int n4, int n5, int n6, float f) {
        int n7 = n6 / n5;
        for (int i = 0; i < n5; ++i) {
            float[] fArray = (float[])objectArray[i];
            FloatSampleTools.float2byteGeneric(fArray, n, byArray, n2, n6, n3, n4, f);
            n2 += n7;
        }
    }

    public static void float2byteInterleaved(float[] fArray, int n, byte[] byArray, int n2, int n3, AudioFormat audioFormat, float f) {
        FloatSampleTools.float2byteGeneric(fArray, n, byArray, n2, audioFormat.getFrameSize() / audioFormat.getChannels(), n3 * audioFormat.getChannels(), audioFormat, f);
    }

    static void float2byteGeneric(float[] fArray, int n, byte[] byArray, int n2, int n3, int n4, AudioFormat audioFormat, float f) {
        int n5 = FloatSampleTools.getFormatType(audioFormat);
        FloatSampleTools.float2byteGeneric(fArray, n, byArray, n2, n3, n4, n5, f);
    }

    static void float2byteGeneric(float[] fArray, int n, byte[] byArray, int n2, int n3, int n4, int n5, float f) {
        if (n < 0 || n + n4 > fArray.length || n4 < 0) {
            throw new IllegalArgumentException("invalid input index: input.length=" + fArray.length + " inOffset=" + n + " sampleCount=" + n4);
        }
        if (n2 < 0 || n2 + n4 * n3 >= byArray.length + n3 || n3 < FloatSampleTools.getSampleSize(n5)) {
            throw new IllegalArgumentException("invalid output index: output.length=" + byArray.length + " outByteOffset=" + n2 + " outByteStep=" + n3 + " sampleCount=" + n4 + " format=" + FloatSampleTools.formatType2Str(n5));
        }
        if (f != 0.0f && random == null) {
            random = new Random();
        }
        int n6 = n + n4;
        int n7 = n2;
        int n8 = n;
        while (n8 < n6) {
            switch (n5) {
                case 9: {
                    byArray[n7] = FloatSampleTools.quantize8(fArray[n8] * 128.0f, f);
                    break;
                }
                case 1: {
                    byArray[n7] = (byte)(FloatSampleTools.quantize8(fArray[n8] * 128.0f, f) + 128);
                    break;
                }
                case 26: {
                    int n9 = FloatSampleTools.quantize16(fArray[n8] * 32768.0f, f);
                    byArray[n7] = (byte)(n9 >> 8);
                    byArray[n7 + 1] = (byte)(n9 & 0xFF);
                    break;
                }
                case 10: {
                    int n9 = FloatSampleTools.quantize16(fArray[n8] * 32768.0f, f);
                    byArray[n7 + 1] = (byte)(n9 >> 8);
                    byArray[n7] = (byte)(n9 & 0xFF);
                    break;
                }
                case 27: {
                    int n9 = FloatSampleTools.quantize24(fArray[n8] * 8388608.0f, f);
                    byArray[n7] = (byte)(n9 >> 16);
                    byArray[n7 + 1] = (byte)(n9 >>> 8 & 0xFF);
                    byArray[n7 + 2] = (byte)(n9 & 0xFF);
                    break;
                }
                case 11: {
                    int n9 = FloatSampleTools.quantize24(fArray[n8] * 8388608.0f, f);
                    byArray[n7 + 2] = (byte)(n9 >> 16);
                    byArray[n7 + 1] = (byte)(n9 >>> 8 & 0xFF);
                    byArray[n7] = (byte)(n9 & 0xFF);
                    break;
                }
                case 28: {
                    int n9 = FloatSampleTools.quantize24(fArray[n8] * 8388608.0f, f);
                    byArray[n7 + 0] = 0;
                    byArray[n7 + 1] = (byte)(n9 >> 16);
                    byArray[n7 + 2] = (byte)(n9 >>> 8 & 0xFF);
                    byArray[n7 + 3] = (byte)(n9 & 0xFF);
                    break;
                }
                case 12: {
                    int n9 = FloatSampleTools.quantize24(fArray[n8] * 8388608.0f, f);
                    byArray[n7 + 3] = (byte)(n9 >> 16);
                    byArray[n7 + 2] = (byte)(n9 >>> 8 & 0xFF);
                    byArray[n7 + 1] = (byte)(n9 & 0xFF);
                    byArray[n7 + 0] = 0;
                    break;
                }
                case 29: {
                    int n9 = FloatSampleTools.quantize32(fArray[n8] * 2.1474836E9f, f);
                    byArray[n7] = (byte)(n9 >> 24);
                    byArray[n7 + 1] = (byte)(n9 >>> 16 & 0xFF);
                    byArray[n7 + 2] = (byte)(n9 >>> 8 & 0xFF);
                    byArray[n7 + 3] = (byte)(n9 & 0xFF);
                    break;
                }
                case 13: {
                    int n9 = FloatSampleTools.quantize32(fArray[n8] * 2.1474836E9f, f);
                    byArray[n7 + 3] = (byte)(n9 >> 24);
                    byArray[n7 + 2] = (byte)(n9 >>> 16 & 0xFF);
                    byArray[n7 + 1] = (byte)(n9 >>> 8 & 0xFF);
                    byArray[n7] = (byte)(n9 & 0xFF);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unsupported format=" + FloatSampleTools.formatType2Str(n5));
                }
            }
            ++n8;
            n7 += n3;
        }
    }
}

