/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.analysis;

import ddf.minim.AudioBuffer;
import ddf.minim.Minim;
import ddf.minim.analysis.BartlettHannWindow;
import ddf.minim.analysis.BartlettWindow;
import ddf.minim.analysis.BlackmanWindow;
import ddf.minim.analysis.CosineWindow;
import ddf.minim.analysis.GaussWindow;
import ddf.minim.analysis.HammingWindow;
import ddf.minim.analysis.HannWindow;
import ddf.minim.analysis.LanczosWindow;
import ddf.minim.analysis.RectangularWindow;
import ddf.minim.analysis.TriangularWindow;
import ddf.minim.analysis.WindowFunction;

public abstract class FourierTransform {
    public static final WindowFunction NONE = new RectangularWindow();
    public static final WindowFunction HAMMING = new HammingWindow();
    public static final WindowFunction HANN = new HannWindow();
    public static final WindowFunction COSINE = new CosineWindow();
    public static final WindowFunction TRIANGULAR = new TriangularWindow();
    public static final WindowFunction BARTLETT = new BartlettWindow();
    public static final WindowFunction BARTLETTHANN = new BartlettHannWindow();
    public static final WindowFunction LANCZOS = new LanczosWindow();
    public static final WindowFunction BLACKMAN = new BlackmanWindow();
    public static final WindowFunction GAUSS = new GaussWindow();
    protected static final int LINAVG = 1;
    protected static final int LOGAVG = 2;
    protected static final int NOAVG = 3;
    protected static final float TWO_PI = (float)Math.PI * 2;
    protected int timeSize;
    protected int sampleRate;
    protected float bandWidth;
    protected WindowFunction currentWindow;
    protected float[] real;
    protected float[] imag;
    protected float[] spectrum;
    protected float[] averages;
    protected int whichAverage;
    protected int octaves;
    protected int avgPerOctave;

    FourierTransform(int n, float f) {
        this.timeSize = n;
        this.sampleRate = (int)f;
        this.bandWidth = 2.0f / (float)this.timeSize * ((float)this.sampleRate / 2.0f);
        this.noAverages();
        this.allocateArrays();
        this.currentWindow = new RectangularWindow();
    }

    protected abstract void allocateArrays();

    protected void setComplex(float[] fArray, float[] fArray2) {
        if (this.real.length != fArray.length && this.imag.length != fArray2.length) {
            Minim.error("FourierTransform.setComplex: the two arrays must be the same length as their member counterparts.");
        } else {
            System.arraycopy(fArray, 0, this.real, 0, fArray.length);
            System.arraycopy(fArray2, 0, this.imag, 0, fArray2.length);
        }
    }

    protected void fillSpectrum() {
        block6: {
            int n;
            block5: {
                for (n = 0; n < this.spectrum.length; ++n) {
                    this.spectrum[n] = (float)Math.sqrt(this.real[n] * this.real[n] + this.imag[n] * this.imag[n]);
                }
                if (this.whichAverage != 1) break block5;
                n = this.spectrum.length / this.averages.length;
                for (int i = 0; i < this.averages.length; ++i) {
                    int n2;
                    int n3;
                    float f = 0.0f;
                    for (n3 = 0; n3 < n && (n2 = n3 + i * n) < this.spectrum.length; ++n3) {
                        f += this.spectrum[n2];
                    }
                    this.averages[i] = f /= (float)(n3 + 1);
                }
                break block6;
            }
            if (this.whichAverage != 2) break block6;
            for (n = 0; n < this.octaves; ++n) {
                float f = n == 0 ? 0.0f : (float)(this.sampleRate / 2) / (float)Math.pow(2.0, this.octaves - n);
                float f2 = (float)(this.sampleRate / 2) / (float)Math.pow(2.0, this.octaves - n - 1);
                float f3 = (f2 - f) / (float)this.avgPerOctave;
                float f4 = f;
                for (int i = 0; i < this.avgPerOctave; ++i) {
                    int n4 = i + n * this.avgPerOctave;
                    this.averages[n4] = this.calcAvg(f4, f4 + f3);
                    f4 += f3;
                }
            }
        }
    }

    public void noAverages() {
        this.averages = new float[0];
        this.whichAverage = 3;
    }

    public void linAverages(int n) {
        if (n > this.spectrum.length / 2) {
            Minim.error("The number of averages for this transform can be at most " + this.spectrum.length / 2 + ".");
            return;
        }
        this.averages = new float[n];
        this.whichAverage = 1;
    }

    public void logAverages(int n, int n2) {
        float f = (float)this.sampleRate / 2.0f;
        this.octaves = 1;
        while (true) {
            float f2;
            f /= 2.0f;
            if (!(f2 > (float)n)) break;
            ++this.octaves;
        }
        Minim.debug("Number of octaves = " + this.octaves);
        this.avgPerOctave = n2;
        this.averages = new float[this.octaves * n2];
        this.whichAverage = 2;
    }

    public void window(WindowFunction windowFunction) {
        this.currentWindow = windowFunction;
    }

    protected void doWindow(float[] fArray) {
        this.currentWindow.apply(fArray);
    }

    public int timeSize() {
        return this.timeSize;
    }

    public int specSize() {
        return this.spectrum.length;
    }

    public float getBand(int n) {
        if (n < 0) {
            n = 0;
        }
        if (n > this.spectrum.length - 1) {
            n = this.spectrum.length - 1;
        }
        return this.spectrum[n];
    }

    public float getBandWidth() {
        return this.bandWidth;
    }

    public float getAverageBandWidth(int n) {
        if (this.whichAverage == 1) {
            int n2 = this.spectrum.length / this.averages.length;
            return (float)n2 * this.getBandWidth();
        }
        if (this.whichAverage == 2) {
            int n3 = n / this.avgPerOctave;
            float f = n3 == 0 ? 0.0f : (float)(this.sampleRate / 2) / (float)Math.pow(2.0, this.octaves - n3);
            float f2 = (float)(this.sampleRate / 2) / (float)Math.pow(2.0, this.octaves - n3 - 1);
            float f3 = (f2 - f) / (float)this.avgPerOctave;
            return f3;
        }
        return 0.0f;
    }

    public abstract void setBand(int var1, float var2);

    public abstract void scaleBand(int var1, float var2);

    public int freqToIndex(float f) {
        if (f < this.getBandWidth() / 2.0f) {
            return 0;
        }
        if (f > (float)(this.sampleRate / 2) - this.getBandWidth() / 2.0f) {
            return this.spectrum.length - 1;
        }
        float f2 = f / (float)this.sampleRate;
        int n = Math.round((float)this.timeSize * f2);
        return n;
    }

    public float indexToFreq(int n) {
        float f = this.getBandWidth();
        if (n == 0) {
            return f * 0.25f;
        }
        if (n == this.spectrum.length - 1) {
            float f2 = (float)(this.sampleRate / 2) - f / 2.0f;
            float f3 = f * 0.25f;
            return f2 + f3;
        }
        return (float)n * f;
    }

    public float getAverageCenterFrequency(int n) {
        if (this.whichAverage == 1) {
            int n2 = this.spectrum.length / this.averages.length;
            int n3 = n * n2 + n2 / 2;
            return this.indexToFreq(n3);
        }
        if (this.whichAverage == 2) {
            int n4 = n / this.avgPerOctave;
            int n5 = n % this.avgPerOctave;
            float f = n4 == 0 ? 0.0f : (float)(this.sampleRate / 2) / (float)Math.pow(2.0, this.octaves - n4);
            float f2 = (float)(this.sampleRate / 2) / (float)Math.pow(2.0, this.octaves - n4 - 1);
            float f3 = (f2 - f) / (float)this.avgPerOctave;
            float f4 = f + (float)n5 * f3;
            return f4 + f3 / 2.0f;
        }
        return 0.0f;
    }

    public float getFreq(float f) {
        return this.getBand(this.freqToIndex(f));
    }

    public void setFreq(float f, float f2) {
        this.setBand(this.freqToIndex(f), f2);
    }

    public void scaleFreq(float f, float f2) {
        this.scaleBand(this.freqToIndex(f), f2);
    }

    public int avgSize() {
        return this.averages.length;
    }

    public float getAvg(int n) {
        float f = this.averages.length > 0 ? this.averages[n] : 0.0f;
        return f;
    }

    public float calcAvg(float f, float f2) {
        int n = this.freqToIndex(f);
        int n2 = this.freqToIndex(f2);
        float f3 = 0.0f;
        for (int i = n; i <= n2; ++i) {
            f3 += this.spectrum[i];
        }
        return f3 /= (float)(n2 - n + 1);
    }

    public float[] getSpectrumReal() {
        return this.real;
    }

    public float[] getSpectrumImaginary() {
        return this.imag;
    }

    public abstract void forward(float[] var1);

    public void forward(float[] fArray, int n) {
        if (fArray.length - n < this.timeSize) {
            Minim.error("FourierTransform.forward: not enough samples in the buffer between " + n + " and " + fArray.length + " to perform a transform.");
            return;
        }
        float[] fArray2 = new float[this.timeSize];
        System.arraycopy(fArray, n, fArray2, 0, fArray2.length);
        this.forward(fArray2);
    }

    public void forward(AudioBuffer audioBuffer) {
        this.forward(audioBuffer.toArray());
    }

    public void forward(AudioBuffer audioBuffer, int n) {
        this.forward(audioBuffer.toArray(), n);
    }

    public abstract void inverse(float[] var1);

    public void inverse(AudioBuffer audioBuffer) {
        this.inverse(audioBuffer.toArray());
    }

    public void inverse(float[] fArray, float[] fArray2, float[] fArray3) {
        this.setComplex(fArray, fArray2);
        this.inverse(fArray3);
    }
}

