/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.ugens;

import ddf.minim.UGen;
import ddf.minim.ugens.Waveform;

public class WaveShaper
extends UGen {
    public UGen.UGenInput audio = new UGen.UGenInput(UGen.InputType.AUDIO);
    public UGen.UGenInput outAmplitude;
    public UGen.UGenInput mapAmplitude = new UGen.UGenInput(UGen.InputType.CONTROL);
    private boolean wrapMap;
    private Waveform mapShape;

    public WaveShaper(float f, float f2, Waveform waveform) {
        this(f, f2, waveform, false);
    }

    public WaveShaper(float f, float f2, Waveform waveform, boolean bl) {
        this.mapAmplitude.setLastValue(f2);
        this.outAmplitude = new UGen.UGenInput(UGen.InputType.CONTROL);
        this.outAmplitude.setLastValue(f);
        this.mapShape = waveform;
        this.wrapMap = bl;
    }

    @Override
    protected void uGenerate(float[] fArray) {
        for (int i = 0; i < fArray.length; ++i) {
            float f = this.mapAmplitude.getLastValue() * this.audio.getLastValues()[i] / 2.0f + 0.5f;
            if (this.wrapMap) {
                if ((f %= 1.0f) < 0.0f) {
                    f += 1.0f;
                }
            } else if (f > 1.0f) {
                f = 1.0f;
            } else if (f < 0.0f) {
                f = 0.0f;
            }
            fArray[i] = this.outAmplitude.getLastValue() * this.mapShape.value(f);
        }
    }
}

