/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.analysis;

import ddf.minim.AudioBuffer;
import ddf.minim.Minim;
import ddf.minim.analysis.FFT;

public class BeatDetect {
    public static final int FREQ_ENERGY = 0;
    public static final int SOUND_ENERGY = 1;
    private int algorithm;
    private int sampleRate;
    private int timeSize;
    private int valCnt;
    private float[] valGraph;
    private int sensitivity;
    private int insertAt;
    private boolean isOnset;
    private float[] eBuffer;
    private float[] dBuffer;
    private long timer;
    private boolean[] fIsOnset;
    private FFT spect;
    private float[][] feBuffer;
    private float[][] fdBuffer;
    private long[] fTimer;
    private float[] varGraph;
    private int varCnt;

    public BeatDetect() {
        this.sampleRate = 44100;
        this.timeSize = 1024;
        this.initSEResources();
        this.initGraphs();
        this.algorithm = 1;
        this.sensitivity = 10;
    }

    public BeatDetect(int n, float f) {
        this.sampleRate = (int)f;
        this.timeSize = n;
        this.initFEResources();
        this.initGraphs();
        this.algorithm = 0;
        this.sensitivity = 10;
    }

    public void detectMode(int n) {
        if (n < 0 || n > 1) {
            Minim.error("Unrecognized detect mode, defaulting to SOUND_ENERGY.");
            n = 1;
        }
        if (n == 1) {
            if (this.algorithm == 0) {
                this.releaseFEResources();
                this.initSEResources();
                this.initGraphs();
                this.algorithm = n;
            }
        } else if (this.algorithm == 1) {
            this.releaseSEResources();
            this.initFEResources();
            this.initGraphs();
            this.algorithm = 0;
        }
    }

    private void initGraphs() {
        this.varCnt = 0;
        this.valCnt = 0;
        this.valGraph = new float[512];
        this.varGraph = new float[512];
    }

    private void initSEResources() {
        this.isOnset = false;
        this.eBuffer = new float[this.sampleRate / this.timeSize];
        this.dBuffer = new float[this.sampleRate / this.timeSize];
        this.timer = System.currentTimeMillis();
        this.insertAt = 0;
    }

    private void initFEResources() {
        this.spect = new FFT(this.timeSize, this.sampleRate);
        this.spect.logAverages(60, 3);
        int n = this.spect.avgSize();
        this.fIsOnset = new boolean[n];
        this.feBuffer = new float[n][this.sampleRate / this.timeSize];
        this.fdBuffer = new float[n][this.sampleRate / this.timeSize];
        this.fTimer = new long[n];
        long l = System.currentTimeMillis();
        for (int i = 0; i < this.fTimer.length; ++i) {
            this.fTimer[i] = l;
        }
        this.insertAt = 0;
    }

    private void releaseSEResources() {
        this.isOnset = false;
        this.eBuffer = null;
        this.dBuffer = null;
        this.timer = 0L;
    }

    private void releaseFEResources() {
        this.spect = null;
        this.fIsOnset = null;
        this.feBuffer = null;
        this.fdBuffer = null;
        this.fTimer = null;
    }

    public void detect(AudioBuffer audioBuffer) {
        this.detect(audioBuffer.toArray());
    }

    public void detect(float[] fArray) {
        switch (this.algorithm) {
            case 1: {
                this.sEnergy(fArray);
                break;
            }
            case 0: {
                this.fEnergy(fArray);
            }
        }
    }

    public int dectectSize() {
        if (this.algorithm == 0) {
            return this.spect.avgSize();
        }
        return 0;
    }

    public float getDetectCenterFrequency(int n) {
        if (this.algorithm == 0) {
            return this.spect.getAverageCenterFrequency(n);
        }
        return 0.0f;
    }

    public void setSensitivity(int n) {
        if (n < 0) {
            Minim.error("BeatDetect: sensitivity cannot be less than zero. Defaulting to 10.");
            this.sensitivity = 10;
        } else {
            this.sensitivity = n;
        }
    }

    public boolean isOnset() {
        return this.isOnset;
    }

    public boolean isOnset(int n) {
        if (this.algorithm == 1) {
            return false;
        }
        return this.fIsOnset[n];
    }

    public boolean isKick() {
        if (this.algorithm == 1) {
            return false;
        }
        int n = 6 >= this.spect.avgSize() ? this.spect.avgSize() : 6;
        return this.isRange(1, n, 2);
    }

    public boolean isSnare() {
        if (this.algorithm == 1) {
            return false;
        }
        int n = 8 >= this.spect.avgSize() ? this.spect.avgSize() : 8;
        int n2 = this.spect.avgSize() - 1;
        int n3 = (n2 - n) / 3 + 1;
        return this.isRange(n, n2, n3);
    }

    public boolean isHat() {
        if (this.algorithm == 1) {
            return false;
        }
        int n = this.spect.avgSize() - 7 < 0 ? 0 : this.spect.avgSize() - 7;
        int n2 = this.spect.avgSize() - 1;
        return this.isRange(n, n2, 1);
    }

    public boolean isRange(int n, int n2, int n3) {
        if (this.algorithm == 1) {
            return false;
        }
        int n4 = 0;
        for (int i = n; i < n2 + 1; ++i) {
            if (!this.isOnset(i)) continue;
            ++n4;
        }
        return n4 >= n3;
    }

    private void sEnergy(float[] fArray) {
        float f = 0.0f;
        for (int i = 0; i < fArray.length; ++i) {
            f += fArray[i] * fArray[i];
        }
        f /= (float)fArray.length;
        f = (float)Math.sqrt(f);
        float f2 = f * 100.0f;
        float f3 = this.average(this.eBuffer);
        float f4 = this.variance(this.eBuffer, f3);
        float f5 = -0.0025714f * f4 + 1.5142857f;
        float f6 = Math.max(f2 - f5 * f3, 0.0f);
        this.pushVal(f6);
        float f7 = this.specAverage(this.dBuffer);
        float f8 = Math.max(f6 - f7, 0.0f);
        this.pushVar(f8);
        if (System.currentTimeMillis() - this.timer < (long)this.sensitivity) {
            this.isOnset = false;
        } else if (f8 > 0.0f && f2 > 2.0f) {
            this.isOnset = true;
            this.timer = System.currentTimeMillis();
        } else {
            this.isOnset = false;
        }
        this.eBuffer[this.insertAt] = f2;
        this.dBuffer[this.insertAt] = f6;
        ++this.insertAt;
        if (this.insertAt == this.eBuffer.length) {
            this.insertAt = 0;
        }
    }

    private void fEnergy(float[] fArray) {
        this.spect.forward(fArray);
        for (int i = 0; i < this.feBuffer.length; ++i) {
            float f = this.spect.getAvg(i);
            float f2 = this.average(this.feBuffer[i]);
            float f3 = this.variance(this.feBuffer[i], f2);
            float f4 = -0.0025714f * f3 + 1.5142857f;
            float f5 = Math.max(f - f4 * f2, 0.0f);
            float f6 = this.specAverage(this.fdBuffer[i]);
            float f7 = Math.max(f5 - f6, 0.0f);
            if (System.currentTimeMillis() - this.fTimer[i] < (long)this.sensitivity) {
                this.fIsOnset[i] = false;
            } else if (f7 > 0.0f) {
                this.fIsOnset[i] = true;
                this.fTimer[i] = System.currentTimeMillis();
            } else {
                this.fIsOnset[i] = false;
            }
            this.feBuffer[i][this.insertAt] = f;
            this.fdBuffer[i][this.insertAt] = f5;
        }
        ++this.insertAt;
        if (this.insertAt == this.feBuffer[0].length) {
            this.insertAt = 0;
        }
    }

    private void pushVal(float f) {
        if (this.valCnt == this.valGraph.length) {
            this.valCnt = 0;
            this.valGraph = new float[this.valGraph.length];
        }
        this.valGraph[this.valCnt] = f;
        ++this.valCnt;
    }

    private void pushVar(float f) {
        if (this.varCnt == this.varGraph.length) {
            this.varCnt = 0;
            this.varGraph = new float[this.varGraph.length];
        }
        this.varGraph[this.varCnt] = f;
        ++this.varCnt;
    }

    private float average(float[] fArray) {
        float f = 0.0f;
        for (int i = 0; i < fArray.length; ++i) {
            f += fArray[i];
        }
        return f /= (float)fArray.length;
    }

    private float specAverage(float[] fArray) {
        float f = 0.0f;
        float f2 = 0.0f;
        for (int i = 0; i < fArray.length; ++i) {
            if (!(fArray[i] > 0.0f)) continue;
            f += fArray[i];
            f2 += 1.0f;
        }
        if (f2 > 0.0f) {
            f /= f2;
        }
        return f;
    }

    private float variance(float[] fArray, float f) {
        float f2 = 0.0f;
        for (int i = 0; i < fArray.length; ++i) {
            f2 += (float)Math.pow(fArray[i] - f, 2.0);
        }
        return f2 /= (float)fArray.length;
    }
}

