/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.ugens;

import ddf.minim.Minim;
import ddf.minim.UGen;

public class BitCrush
extends UGen {
    public UGen.UGenInput audio = new UGen.UGenInput(UGen.InputType.AUDIO);
    public UGen.UGenInput bitRes = new UGen.UGenInput(UGen.InputType.CONTROL);
    public UGen.UGenInput bitRate;
    float[] sampledFrame;
    int sampleCounter;

    public BitCrush() {
        this(1.0f, 44100.0f);
    }

    public BitCrush(float f, float f2) {
        this.bitRes.setLastValue(f);
        this.bitRate = new UGen.UGenInput(UGen.InputType.CONTROL);
        this.bitRate.setLastValue(f2);
        this.sampledFrame = new float[this.channelCount()];
    }

    @Override
    protected void channelCountChanged() {
        this.sampledFrame = new float[this.channelCount()];
        this.sampleCounter = 0;
    }

    public void setBitRes(float f) {
        this.bitRes.setLastValue(f);
    }

    @Override
    protected void uGenerate(float[] fArray) {
        if (this.sampleCounter <= 0) {
            if (this.audio.getLastValues().length != this.channelCount()) {
                Minim.error("BitCrush audio has " + this.audio.getLastValues().length + " channels and sampledFrame has " + this.channelCount());
            }
            System.arraycopy(this.audio.getLastValues(), 0, this.sampledFrame, 0, this.channelCount());
            this.sampleCounter = (int)(this.sampleRate() / Math.max(this.bitRate.getLastValue(), 1.0f));
        }
        int n = 1 << (int)this.bitRes.getLastValue();
        for (int i = 0; i < fArray.length; ++i) {
            int n2 = (int)((float)n * this.sampledFrame[i]);
            fArray[i] = (float)n2 / (float)n;
        }
        --this.sampleCounter;
    }
}

