/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim;

import ddf.minim.Recordable;
import ddf.minim.spi.AudioRecordingStream;
import ddf.minim.spi.SampleRecorder;

public class AudioRecorder {
    private Recordable source;
    private SampleRecorder recorder;

    public AudioRecorder(Recordable recordable, SampleRecorder sampleRecorder) {
        this.source = recordable;
        this.recorder = sampleRecorder;
        this.source.addListener(sampleRecorder);
    }

    public void beginRecord() {
        this.recorder.beginRecord();
    }

    public void endRecord() {
        this.recorder.endRecord();
    }

    public boolean isRecording() {
        return this.recorder.isRecording();
    }

    public AudioRecordingStream save() {
        return this.recorder.save();
    }

    public void setRecordSource(Recordable recordable) {
        this.source.removeListener(this.recorder);
        this.source = recordable;
        this.source.addListener(this.recorder);
    }

    public void setSampleRecorder(SampleRecorder sampleRecorder) {
        this.recorder.endRecord();
        this.recorder.save();
        this.source.removeListener(this.recorder);
        this.source.addListener(sampleRecorder);
        this.recorder = sampleRecorder;
    }
}

