/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.javasound;

import ddf.minim.AudioMetaData;
import ddf.minim.AudioSample;
import ddf.minim.AudioSignal;
import ddf.minim.Minim;
import ddf.minim.Recordable;
import ddf.minim.javasound.BasicMetaData;
import ddf.minim.javasound.FloatSampleBuffer;
import ddf.minim.javasound.JSAudioInput;
import ddf.minim.javasound.JSAudioOutput;
import ddf.minim.javasound.JSAudioRecording;
import ddf.minim.javasound.JSAudioRecordingClip;
import ddf.minim.javasound.JSAudioSample;
import ddf.minim.javasound.JSBaseAudioRecordingStream;
import ddf.minim.javasound.JSBufferedSampleRecorder;
import ddf.minim.javasound.JSMPEGAudioRecordingStream;
import ddf.minim.javasound.JSPCMAudioRecordingStream;
import ddf.minim.javasound.JSStreamingSampleRecorder;
import ddf.minim.javasound.MP3MetaData;
import ddf.minim.javasound.MpegAudioFileReader;
import ddf.minim.javasound.MpegAudioFileReaderWorkaround;
import ddf.minim.javasound.SampleSignal;
import ddf.minim.spi.AudioOut;
import ddf.minim.spi.AudioRecording;
import ddf.minim.spi.AudioRecordingStream;
import ddf.minim.spi.AudioStream;
import ddf.minim.spi.MinimServiceProvider;
import ddf.minim.spi.SampleRecorder;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import javazoom.spi.mpeg.sampled.convert.MpegFormatConversionProvider;
import javazoom.spi.mpeg.sampled.file.MpegAudioFormat;
import org.tritonus.share.sampled.AudioUtils;
import org.tritonus.share.sampled.file.TAudioFileFormat;

public class JSMinim
implements MinimServiceProvider {
    private boolean debug = false;
    private Object fileLoader;
    private Method sketchPath;
    private Method createInput;
    private Mixer inputMixer;
    private Mixer outputMixer;

    public JSMinim(Object object) {
        this.fileLoader = object;
        this.inputMixer = null;
        this.outputMixer = null;
        String string = "";
        try {
            this.sketchPath = object.getClass().getMethod("sketchPath", String.class);
            if (this.sketchPath.getReturnType() != String.class) {
                string = string + "The method sketchPath in the file loading object provided does not return a String!\n";
                this.sketchPath = null;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            string = string + "Couldn't find a sketchPath method on the file loading object provided!\n";
        }
        catch (Exception exception) {
            string = string + "Failed to get method sketchPath from file loading object provided!\n" + exception.getMessage() + "\n";
        }
        if (string.length() > 0) {
            string = string + "File recording will be disabled.";
            this.error(string);
        }
        string = "";
        try {
            this.createInput = object.getClass().getMethod("createInput", String.class);
            if (this.createInput.getReturnType() != InputStream.class) {
                string = string + "The method createInput in the file loading object provided does not return an InputStream!\n";
                this.createInput = null;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            string = string + "Couldn't find a createInput method in the file loading object provided!\n";
        }
        catch (Exception exception) {
            string = string + "Failed to get method createInput from the file loading object provided!\n" + exception.getMessage() + "\n";
        }
        if (string.length() > 0) {
            string = string + "File loading will be disabled.";
            this.error(string);
        }
    }

    public void setInputMixer(Mixer mixer) {
        this.inputMixer = mixer;
    }

    public Mixer getInputMixer() {
        return this.inputMixer;
    }

    public void setOutputMixer(Mixer mixer) {
        this.outputMixer = mixer;
    }

    public Mixer getOutputMixer() {
        return this.outputMixer;
    }

    public void start() {
    }

    public void stop() {
    }

    public void debugOn() {
        this.debug = true;
    }

    public void debugOff() {
        this.debug = false;
    }

    void debug(String string) {
        if (this.debug) {
            System.out.println("==== JavaSound Minim Debug ====");
            String[] stringArray = string.split("\n");
            for (int i = 0; i < stringArray.length; ++i) {
                System.out.println("==== " + stringArray[i]);
            }
            System.out.println();
        }
    }

    void error(String string) {
        System.out.println("==== JavaSound Minim Error ====");
        String[] stringArray = string.split("\n");
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.println("==== " + stringArray[i]);
        }
        System.out.println();
    }

    public SampleRecorder getSampleRecorder(Recordable recordable, String string, boolean bl) {
        if (this.sketchPath == null) {
            return null;
        }
        String string2 = string.substring(string.lastIndexOf(46) + 1).toLowerCase();
        this.debug("createRecorder: file extension is " + string2 + ".");
        AudioFileFormat.Type type = null;
        if (string2.equals(Minim.WAV.getExtension())) {
            type = Minim.WAV;
        } else if (string2.equals(Minim.AIFF.getExtension()) || string2.equals("aif")) {
            type = Minim.AIFF;
        } else if (string2.equals(Minim.AIFC.getExtension())) {
            type = Minim.AIFC;
        } else if (string2.equals(Minim.AU.getExtension())) {
            type = Minim.AU;
        } else if (string2.equals(Minim.SND.getExtension())) {
            type = Minim.SND;
        } else {
            this.error("The extension " + string2 + " is not a recognized audio file type.");
            return null;
        }
        Object object = null;
        try {
            String string3 = (String)this.sketchPath.invoke(this.fileLoader, string);
            object = bl ? new JSBufferedSampleRecorder(this, string3, type, recordable.getFormat(), recordable.bufferSize()) : new JSStreamingSampleRecorder(this, string3, type, recordable.getFormat(), recordable.bufferSize());
        }
        catch (Exception exception) {
            Minim.error((String)("Couldn't invoke the sketchPath method: " + exception.getMessage()));
        }
        return object;
    }

    public AudioRecordingStream getAudioRecordingStream(String string, int n, boolean bl) {
        JSBaseAudioRecordingStream jSBaseAudioRecordingStream = null;
        AudioInputStream audioInputStream = this.getAudioInputStream(string);
        if (bl && audioInputStream.markSupported()) {
            audioInputStream.mark((int)audioInputStream.getFrameLength() * audioInputStream.getFormat().getFrameSize());
        }
        this.debug("Reading from " + audioInputStream.getClass().toString());
        if (audioInputStream != null) {
            this.debug("File format is: " + audioInputStream.getFormat().toString());
            AudioFormat audioFormat = audioInputStream.getFormat();
            if (audioFormat instanceof MpegAudioFormat) {
                AudioFormat audioFormat2 = audioFormat;
                audioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, audioFormat2.getSampleRate(), 16, audioFormat2.getChannels(), audioFormat2.getChannels() * 2, audioFormat2.getSampleRate(), false);
                AudioInputStream audioInputStream2 = this.getAudioInputStream(audioFormat, audioInputStream);
                SourceDataLine sourceDataLine = this.getSourceDataLine(audioFormat, n);
                if (audioInputStream2 != null && sourceDataLine != null) {
                    Object object;
                    Map<String, Object> map = this.getID3Tags(string);
                    long l = -1L;
                    if (map.containsKey("duration") && (Long)(object = (Long)map.get("duration")) > 0L) {
                        l = (Long)object / 1000L;
                    }
                    object = new MP3MetaData(string, l, map);
                    jSBaseAudioRecordingStream = new JSMPEGAudioRecordingStream(this, (AudioMetaData)object, audioInputStream, audioInputStream2, sourceDataLine, n);
                }
            } else {
                SourceDataLine sourceDataLine = this.getSourceDataLine(audioFormat, n);
                if (sourceDataLine != null) {
                    long l = AudioUtils.frames2Millis((long)audioInputStream.getFrameLength(), (AudioFormat)audioFormat);
                    BasicMetaData basicMetaData = new BasicMetaData(string, l, audioInputStream.getFrameLength());
                    jSBaseAudioRecordingStream = new JSPCMAudioRecordingStream(this, basicMetaData, audioInputStream, sourceDataLine, n);
                }
            }
        }
        return jSBaseAudioRecordingStream;
    }

    private Map<String, Object> getID3Tags(String string) {
        this.debug("Getting the properties.");
        Map<String, Object> map = new HashMap<String, Object>();
        try {
            MpegAudioFileReader mpegAudioFileReader = new MpegAudioFileReader(this);
            InputStream inputStream = (InputStream)this.createInput.invoke(this.fileLoader, string);
            AudioFileFormat audioFileFormat = mpegAudioFileReader.getAudioFileFormat(inputStream, inputStream.available());
            inputStream.close();
            if (audioFileFormat instanceof TAudioFileFormat) {
                TAudioFileFormat tAudioFileFormat = (TAudioFileFormat)audioFileFormat;
                map = tAudioFileFormat.properties();
                if (map.size() == 0) {
                    this.error("No file properties available for " + string + ".");
                } else {
                    this.debug("File properties: " + map.toString());
                }
            }
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            this.error("Couldn't get the file format for " + string + ": " + unsupportedAudioFileException.getMessage());
        }
        catch (IOException iOException) {
            this.error("Couldn't access " + string + ": " + iOException.getMessage());
        }
        catch (Exception exception) {
            this.error("Error invoking createInput on the file loader object: " + exception.getMessage());
        }
        return map;
    }

    public AudioStream getAudioInput(int n, int n2, float f, int n3) {
        if (n3 != 8 && n3 != 16) {
            throw new IllegalArgumentException("Unsupported bit depth, use either 8 or 16.");
        }
        AudioFormat audioFormat = new AudioFormat(f, n3, n, true, false);
        TargetDataLine targetDataLine = this.getTargetDataLine(audioFormat, n2 * 4);
        if (targetDataLine != null) {
            return new JSAudioInput(targetDataLine, n2);
        }
        return null;
    }

    public AudioSample getAudioSample(String string, int n) {
        AudioInputStream audioInputStream = this.getAudioInputStream(string);
        if (audioInputStream != null) {
            Object object;
            AudioFormat audioFormat;
            BasicMetaData basicMetaData = null;
            AudioFormat audioFormat2 = audioInputStream.getFormat();
            FloatSampleBuffer floatSampleBuffer = null;
            if (audioFormat2 instanceof MpegAudioFormat) {
                audioFormat = audioFormat2;
                audioFormat2 = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, audioFormat.getSampleRate(), 16, audioFormat.getChannels(), audioFormat.getChannels() * 2, audioFormat.getSampleRate(), false);
                audioInputStream = this.getAudioInputStream(audioFormat2, audioInputStream);
                object = this.getID3Tags(string);
                long l = (Long)object.get("duration");
                int n2 = (int)AudioUtils.millis2Bytes((long)(l / 1000L), (AudioFormat)audioFormat2);
                floatSampleBuffer = this.loadFloatAudio(audioInputStream, n2);
                basicMetaData = new MP3MetaData(string, l / 1000L, (Map<String, Object>)object);
            } else {
                floatSampleBuffer = this.loadFloatAudio(audioInputStream, (int)audioInputStream.getFrameLength() * audioFormat2.getFrameSize());
                long l = AudioUtils.frames2Millis((long)floatSampleBuffer.getSampleCount(), (AudioFormat)audioFormat2);
                basicMetaData = new BasicMetaData(string, l, floatSampleBuffer.getSampleCount());
            }
            audioFormat = this.getAudioOutput(audioFormat2.getChannels(), n, audioFormat2.getSampleRate(), audioFormat2.getSampleSizeInBits());
            if (audioFormat != null) {
                object = new SampleSignal(floatSampleBuffer);
                audioFormat.setAudioSignal((AudioSignal)object);
                return new JSAudioSample(basicMetaData, (SampleSignal)object, (AudioOut)audioFormat);
            }
            this.error("Couldn't acquire an output.");
        }
        return null;
    }

    public AudioSample getAudioSample(float[] fArray, AudioFormat audioFormat, int n) {
        FloatSampleBuffer floatSampleBuffer = new FloatSampleBuffer(1, fArray.length, audioFormat.getSampleRate());
        System.arraycopy(fArray, 0, floatSampleBuffer.getChannel(0), 0, fArray.length);
        return this.getAudioSampleImp(floatSampleBuffer, audioFormat, n);
    }

    public AudioSample getAudioSample(float[] fArray, float[] fArray2, AudioFormat audioFormat, int n) {
        FloatSampleBuffer floatSampleBuffer = new FloatSampleBuffer(2, fArray.length, audioFormat.getSampleRate());
        System.arraycopy(fArray, 0, floatSampleBuffer.getChannel(0), 0, fArray.length);
        System.arraycopy(fArray2, 0, floatSampleBuffer.getChannel(1), 0, fArray2.length);
        return this.getAudioSampleImp(floatSampleBuffer, audioFormat, n);
    }

    private JSAudioSample getAudioSampleImp(FloatSampleBuffer floatSampleBuffer, AudioFormat audioFormat, int n) {
        AudioOut audioOut = this.getAudioOutput(floatSampleBuffer.getChannelCount(), n, audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits());
        if (audioOut != null) {
            SampleSignal sampleSignal = new SampleSignal(floatSampleBuffer);
            audioOut.setAudioSignal((AudioSignal)sampleSignal);
            long l = AudioUtils.frames2Millis((long)floatSampleBuffer.getSampleCount(), (AudioFormat)audioFormat);
            BasicMetaData basicMetaData = new BasicMetaData(floatSampleBuffer.toString(), l, floatSampleBuffer.getSampleCount());
            return new JSAudioSample(basicMetaData, sampleSignal, audioOut);
        }
        this.error("Couldn't acquire an output.");
        return null;
    }

    public AudioOut getAudioOutput(int n, int n2, float f, int n3) {
        if (n3 != 8 && n3 != 16) {
            throw new IllegalArgumentException("Unsupported bit depth, use either 8 or 16.");
        }
        AudioFormat audioFormat = new AudioFormat(f, n3, n, true, false);
        SourceDataLine sourceDataLine = this.getSourceDataLine(audioFormat, n2);
        if (sourceDataLine != null) {
            return new JSAudioOutput(sourceDataLine, n2);
        }
        return null;
    }

    public AudioRecording getAudioRecordingClip(String string) {
        Clip clip = null;
        BasicMetaData basicMetaData = null;
        AudioInputStream audioInputStream = this.getAudioInputStream(string);
        if (audioInputStream != null) {
            Object object;
            AudioFormat audioFormat = audioInputStream.getFormat();
            if (audioFormat instanceof MpegAudioFormat) {
                object = audioFormat;
                audioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, ((AudioFormat)object).getSampleRate(), 16, ((AudioFormat)object).getChannels(), ((AudioFormat)object).getChannels() * 2, ((AudioFormat)object).getSampleRate(), false);
                audioInputStream = this.getAudioInputStream(audioFormat, audioInputStream);
            }
            if (AudioSystem.isLineSupported((Line.Info)(object = new DataLine.Info(Clip.class, audioInputStream.getFormat())))) {
                try {
                    clip = (Clip)AudioSystem.getLine((Line.Info)object);
                    clip.open(audioInputStream);
                }
                catch (Exception exception) {
                    this.error("Error obtaining Javasound Clip: " + exception.getMessage());
                    return null;
                }
                Map<String, Object> map = this.getID3Tags(string);
                long l = -1L;
                if (map.containsKey("duration")) {
                    Long l2 = (Long)map.get("duration");
                    l = l2 / 1000L;
                }
                basicMetaData = new MP3MetaData(string, l, map);
            } else {
                this.error("File format not supported.");
                return null;
            }
        }
        if (basicMetaData == null) {
            basicMetaData = new BasicMetaData(string, clip.getMicrosecondLength() / 1000L, -1L);
        }
        return new JSAudioRecordingClip(clip, basicMetaData);
    }

    public AudioRecording getAudioRecording(String string) {
        BasicMetaData basicMetaData = null;
        AudioInputStream audioInputStream = this.getAudioInputStream(string);
        if (audioInputStream != null) {
            byte[] byArray;
            Object object;
            AudioFormat audioFormat = audioInputStream.getFormat();
            if (audioFormat instanceof MpegAudioFormat) {
                object = audioFormat;
                audioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, ((AudioFormat)object).getSampleRate(), 16, ((AudioFormat)object).getChannels(), ((AudioFormat)object).getChannels() * 2, ((AudioFormat)object).getSampleRate(), false);
                audioInputStream = this.getAudioInputStream(audioFormat, audioInputStream);
                Map<String, Object> map = this.getID3Tags(string);
                long l = (Long)map.get("duration");
                int n = (int)AudioUtils.millis2Bytes((long)(l / 1000L), (AudioFormat)audioFormat);
                byArray = this.loadByteAudio(audioInputStream, n);
                basicMetaData = new MP3MetaData(string, l / 1000L, map);
            } else {
                byArray = this.loadByteAudio(audioInputStream, (int)audioInputStream.getFrameLength() * audioFormat.getFrameSize());
                long l = AudioUtils.bytes2Millis((long)byArray.length, (AudioFormat)audioFormat);
                basicMetaData = new BasicMetaData(string, l, byArray.length);
            }
            object = this.getSourceDataLine(audioFormat, 2048);
            if (object != null) {
                return new JSAudioRecording(this, byArray, (SourceDataLine)object, basicMetaData);
            }
        }
        return null;
    }

    private FloatSampleBuffer loadFloatAudio(AudioInputStream audioInputStream, int n) {
        int n2;
        FloatSampleBuffer floatSampleBuffer = new FloatSampleBuffer();
        byte[] byArray = new byte[n];
        try {
            int n3;
            for (n2 = 0; n2 < n && (n3 = audioInputStream.read(byArray, n2, n - n2)) >= 1; n2 += n3) {
            }
            audioInputStream.close();
        }
        catch (Exception exception) {
            this.error("Error loading file into memory: " + exception.getMessage());
        }
        this.debug("Needed to read " + n + " actually read " + n2);
        floatSampleBuffer.initFromByteArray(byArray, 0, n2, audioInputStream.getFormat());
        return floatSampleBuffer;
    }

    private byte[] loadByteAudio(AudioInputStream audioInputStream, int n) {
        int n2;
        byte[] byArray = new byte[n];
        try {
            int n3;
            for (n2 = 0; n2 < n && (n3 = audioInputStream.read(byArray, n2, n - n2)) >= 1; n2 += n3) {
            }
            audioInputStream.close();
        }
        catch (Exception exception) {
            this.error("Error loading file into memory: " + exception.getMessage());
        }
        this.debug("Needed to read " + n + " actually read " + n2);
        return byArray;
    }

    AudioInputStream getAudioInputStream(String string) {
        AudioInputStream audioInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        if (string.startsWith("http")) {
            try {
                audioInputStream = this.getAudioInputStream(new URL(string));
            }
            catch (MalformedURLException malformedURLException) {
                this.error("Bad URL: " + malformedURLException.getMessage());
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                this.error("URL is in an unsupported audio file format: " + unsupportedAudioFileException.getMessage());
            }
            catch (IOException iOException) {
                Minim.error((String)("Error reading the URL: " + iOException.getMessage()));
            }
        } else {
            try {
                InputStream inputStream = (InputStream)this.createInput.invoke(this.fileLoader, string);
                this.debug("Base input stream is: " + inputStream.toString());
                bufferedInputStream = new BufferedInputStream(inputStream);
                audioInputStream = this.getAudioInputStream(bufferedInputStream);
                this.debug("Acquired AudioInputStream.\nIt is " + audioInputStream.getFrameLength() + " frames long.\n" + "Marking support: " + audioInputStream.markSupported());
            }
            catch (IOException iOException) {
                this.error("IOException: " + iOException.getMessage());
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                this.error("Unsupported Audio File: " + unsupportedAudioFileException.getMessage());
            }
            catch (Exception exception) {
                this.error("Error invoking createInput on the file loader object: " + exception.getMessage());
            }
        }
        return audioInputStream;
    }

    AudioInputStream getAudioInputStream(URL uRL) throws UnsupportedAudioFileException, IOException {
        return new MpegAudioFileReaderWorkaround(this).getAudioInputStream(uRL, null);
    }

    AudioInputStream getAudioInputStream(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        try {
            return AudioSystem.getAudioInputStream(inputStream);
        }
        catch (Exception exception) {
            this.debug("Using AppletMpegSPIWorkaround to get codec");
            return new MpegAudioFileReader(this).getAudioInputStream(inputStream);
        }
    }

    AudioInputStream getAudioInputStream(AudioFormat audioFormat, AudioInputStream audioInputStream) {
        try {
            return AudioSystem.getAudioInputStream(audioFormat, audioInputStream);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.debug("Using AppletMpegSPIWorkaround to get codec");
            try {
                Class.forName("javazoom.spi.mpeg.sampled.convert.MpegFormatConversionProvider");
                return new MpegFormatConversionProvider().getAudioInputStream(audioFormat, audioInputStream);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalArgumentException("Mpeg codec not properly installed");
            }
        }
    }

    SourceDataLine getSourceDataLine(AudioFormat audioFormat, int n) {
        SourceDataLine sourceDataLine = null;
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
        if (AudioSystem.isLineSupported(info)) {
            try {
                sourceDataLine = this.outputMixer == null ? (SourceDataLine)AudioSystem.getLine(info) : (SourceDataLine)this.outputMixer.getLine(info);
                sourceDataLine.open(audioFormat, n * audioFormat.getFrameSize() * 4);
                if (sourceDataLine.isOpen()) {
                    this.debug("SourceDataLine is " + sourceDataLine.getClass().toString() + "\n" + "Buffer size is " + sourceDataLine.getBufferSize() + " bytes.\n" + "Format is " + sourceDataLine.getFormat().toString() + ".");
                    return sourceDataLine;
                }
            }
            catch (LineUnavailableException lineUnavailableException) {
                this.error("Couldn't open the line: " + lineUnavailableException.getMessage());
            }
        }
        this.error("Unable to return a SourceDataLine: unsupported format - " + audioFormat.toString());
        return sourceDataLine;
    }

    TargetDataLine getTargetDataLine(AudioFormat audioFormat, int n) {
        TargetDataLine targetDataLine = null;
        DataLine.Info info = new DataLine.Info(TargetDataLine.class, audioFormat);
        if (AudioSystem.isLineSupported(info)) {
            try {
                targetDataLine = this.inputMixer == null ? (TargetDataLine)AudioSystem.getLine(info) : (TargetDataLine)this.inputMixer.getLine(info);
                targetDataLine.open(audioFormat, n * audioFormat.getFrameSize());
                this.debug("TargetDataLine buffer size is " + targetDataLine.getBufferSize() + "\n" + "TargetDataLine format is " + targetDataLine.getFormat().toString() + "\n" + "TargetDataLine info is " + targetDataLine.getLineInfo().toString());
            }
            catch (Exception exception) {
                this.error("Error acquiring TargetDataLine: " + exception.getMessage());
            }
        } else {
            this.error("Unable to return a TargetDataLine: unsupported format - " + audioFormat.toString());
        }
        return targetDataLine;
    }
}

