/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.effects;

import ddf.minim.AudioEffect;
import ddf.minim.Minim;

public class Convolver
implements AudioEffect {
    protected float[] kernal;
    protected float[] outputL;
    protected float[] overlapL;
    protected float[] outputR;
    protected float[] overlapR;
    protected int sigLen;

    public Convolver(float[] fArray, int n) {
        this.sigLen = n;
        this.setKernal(fArray);
    }

    public void setKernal(float[] fArray) {
        this.kernal = new float[fArray.length];
        System.arraycopy(fArray, 0, this.kernal, 0, fArray.length);
        this.outputL = new float[this.sigLen + this.kernal.length - 1];
        this.outputR = new float[this.sigLen + this.kernal.length - 1];
        this.overlapL = new float[this.outputL.length - this.sigLen];
        this.overlapR = new float[this.outputR.length - this.sigLen];
    }

    @Override
    public void process(float[] fArray) {
        int n;
        if (fArray.length != this.sigLen) {
            Minim.error("Convolver.process: signal.length does not equal sigLen, no processing will occurr.");
            return;
        }
        System.arraycopy(this.outputL, fArray.length, this.overlapL, 0, this.overlapL.length);
        for (n = 0; n < this.outputL.length; ++n) {
            this.outputL[n] = 0.0f;
            for (int i = 0; i < this.kernal.length; ++i) {
                if (n - i < 0 || n - i > fArray.length) continue;
                int n2 = n;
                this.outputL[n2] = this.outputL[n2] + this.kernal[i] * fArray[n - i];
            }
        }
        System.arraycopy(this.outputL, 0, fArray, 0, fArray.length);
        for (n = 0; n < this.overlapL.length; ++n) {
            int n3 = n;
            fArray[n3] = fArray[n3] + this.overlapL[n];
        }
    }

    @Override
    public void process(float[] fArray, float[] fArray2) {
        int n;
        if (fArray.length != this.sigLen || fArray2.length != this.sigLen) {
            Minim.error("Convolver.process: signal.length does not equal sigLen, no processing will occurr.");
            return;
        }
        System.arraycopy(this.outputL, fArray.length, this.overlapL, 0, this.overlapL.length);
        System.arraycopy(this.outputR, fArray2.length, this.overlapR, 0, this.overlapR.length);
        for (n = 0; n < this.outputL.length; ++n) {
            this.outputL[n] = 0.0f;
            this.outputR[n] = 0.0f;
            for (int i = 0; i < this.kernal.length; ++i) {
                if (n - i < 0 || n - i >= fArray.length) continue;
                int n2 = n;
                this.outputL[n2] = this.outputL[n2] + this.kernal[i] * fArray[n - i];
                int n3 = n;
                this.outputR[n3] = this.outputR[n3] + this.kernal[i] * fArray2[n - i];
            }
        }
        System.arraycopy(this.outputL, 0, fArray, 0, fArray.length);
        System.arraycopy(this.outputR, 0, fArray2, 0, fArray2.length);
        for (n = 0; n < this.overlapL.length; ++n) {
            int n4 = n;
            fArray[n4] = fArray[n4] + this.overlapL[n];
            int n5 = n;
            fArray2[n5] = fArray2[n5] + this.overlapR[n];
        }
    }
}

